/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.model.internal;

import com.liferay.ide.hook.core.model.BeforeAfterFilterType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public class BeforeAfterFilterTypeBinding
extends XmlValueBindingImpl {
    private String defaultValueText;
    private String localValue;

    public void init(Property property) {
        super.init(property);
        DefaultValue defaultValue = (DefaultValue)property.definition().getAnnotation(DefaultValue.class);
        this.defaultValueText = defaultValue.text();
    }

    public String read() {
        XmlElement xmlElement = this.xml();
        XmlElement beforeFilterElement = xmlElement.getChildElement(BeforeAfterFilterType.BEFORE_FILTER.getText(), false);
        if (beforeFilterElement != null) {
            return BeforeAfterFilterType.BEFORE_FILTER.getText();
        }
        XmlElement afterFilterElement = xmlElement.getChildElement(BeforeAfterFilterType.AFTER_FILTER.getText(), false);
        if (afterFilterElement != null) {
            return BeforeAfterFilterType.AFTER_FILTER.getText();
        }
        if (this.localValue != null) {
            return this.localValue;
        }
        return this.defaultValueText;
    }

    public void write(String value) {
        XmlElement xmlElement = this.xml();
        XmlElement filterElement = xmlElement.getChildElement(BeforeAfterFilterType.BEFORE_FILTER.getText(), false);
        if (filterElement == null) {
            filterElement = xmlElement.getChildElement(BeforeAfterFilterType.AFTER_FILTER.getText(), false);
        }
        String existingFilterValue = null;
        if (filterElement != null) {
            existingFilterValue = filterElement.getText();
            filterElement.remove();
            XmlElement newElement = xmlElement.getChildElement(value, true);
            newElement.setText(existingFilterValue);
        } else {
            this.localValue = value;
        }
    }
}

