/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.model.internal;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.core.model.Hook;
import com.liferay.ide.hook.core.model.StrutsAction;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsActionPathPossibleValuesService
extends PossibleValuesService {
    private IPath portalDir;
    private TreeSet<String> possibleValues;

    protected void fillPossibleValues(Set<String> values) {
        if (this.portalDir != null && this.portalDir.toFile().exists()) {
            if (this.possibleValues == null) {
                this.possibleValues = new TreeSet();
                File strutsConfigFile = this.portalDir.append("WEB-INF/struts-config.xml").toFile();
                if (strutsConfigFile.exists()) {
                    try {
                        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(strutsConfigFile);
                        NodeList actions = doc.getElementsByTagName("action");
                        if (actions != null) {
                            int i = 0;
                            while (i < actions.getLength()) {
                                Node action = actions.item(i);
                                Node path = action.getAttributes().getNamedItem("path");
                                if (path != null) {
                                    this.possibleValues.add(path.getNodeValue());
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            values.addAll(this.possibleValues);
            String actionPath = (String)((StrutsAction)this.context(StrutsAction.class)).getStrutsActionPath().content(false);
            if (!CoreUtil.empty((String)actionPath)) {
                values.add(actionPath);
            }
        }
    }

    protected void init() {
        super.init();
        ILiferayProject liferayProject = LiferayCore.create((Object)this.project());
        if (liferayProject != null) {
            this.portalDir = liferayProject.getAppServerPortalDir();
        }
    }

    protected Hook hook() {
        return (Hook)this.context().find(Hook.class);
    }

    protected IProject project() {
        return (IProject)this.hook().adapt(IProject.class);
    }
}

