/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.hook.core.operation;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.hook.core.HookCore;
import com.liferay.ide.hook.core.dd.HookDescriptorHelper;
import com.liferay.ide.hook.core.operation.AddHookOperation;
import com.liferay.ide.hook.core.operation.INewHookDataModelProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class NewHookDataModelProvider
extends ArtifactEditOperationDataModelProvider
implements INewHookDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new AddHookOperation(this.getDataModel());
    }

    public Object getDefaultProperty(String propertyName) {
        if ("INewHookDataModelProperties.CUSTOM_JSPS_FOLDER".equals(propertyName)) {
            IProject targetProject = this.getTargetProject();
            if (targetProject != null) {
                IFolder defaultWebappRoot;
                IVirtualFolder webappRoot;
                HookDescriptorHelper hookDescriptorHelper = new HookDescriptorHelper(targetProject);
                String customJspFolder = hookDescriptorHelper.getCustomJSPFolder(this.getDataModel());
                if (customJspFolder != null && (webappRoot = CoreUtil.getDocroot((IProject)targetProject)) != null) {
                    IVirtualFolder virtualJspFolder = webappRoot.getFolder(customJspFolder);
                    IContainer[] iContainerArray = virtualJspFolder.getUnderlyingFolders();
                    int n = iContainerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer container = iContainerArray[n2];
                        if (container != null && container.exists()) {
                            return container.getFullPath().toPortableString();
                        }
                        ++n2;
                    }
                }
                if ((defaultWebappRoot = CoreUtil.getDefaultDocrootFolder((IProject)targetProject)) != null) {
                    return defaultWebappRoot.getFullPath().append("custom_jsps").toPortableString();
                }
            }
        } else if ("INewHookDataModelProperties.PORTAL_PROPERTIES_FILE".equals(propertyName)) {
            IProject targetProject = this.getTargetProject();
            if (targetProject != null) {
                return CoreUtil.getFirstSrcFolder((IProject)targetProject).getFullPath().append("portal.properties").toPortableString();
            }
        } else if ("INewHookDataModelProperties.CONTENT_FOLDER".equals(propertyName)) {
            IProject targetProject = this.getTargetProject();
            if (targetProject != null) {
                return CoreUtil.getFirstSrcFolder((IProject)targetProject).getFullPath().append("content").toPortableString();
            }
        } else {
            if (propertyName.equals("NewJavaClassDataModel.PROJECT")) {
                return this.getTargetProject();
            }
            if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
                IFolder sourceFolder = this.getDefaultJavaSourceFolder();
                if (sourceFolder != null && sourceFolder.exists()) {
                    return sourceFolder.getFullPath().toPortableString();
                }
            } else {
                if (propertyName.equals("NewJavaClassDataModel.JAVA_SOURCE_FOLDER")) {
                    return this.getJavaSourceFolder();
                }
                if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT")) {
                    return this.getJavaPackageFragmentRoot();
                }
                if ("INewHookDataModelProperties.CUSTOM_JSPS_FILES_CREATED".equals(propertyName)) {
                    return new HashSet();
                }
                if ("INewHookDataModelProperties.LANGUAGE_PROPERTIES_FILES_CREATED".equals(propertyName)) {
                    return new HashSet();
                }
                if ("INewHookDataModelProperties.DISABLE_CUSTOM_JSP_FOLDER_VALIDATION".equals(propertyName)) {
                    return true;
                }
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("INewHookDataModelProperties.CREATE_CUSTOM_JSPS");
        propertyNames.add("INewHookDataModelProperties.CREATE_PORTAL_PROPERTIES");
        propertyNames.add("INewHookDataModelProperties.CREATE_SERVICES");
        propertyNames.add("INewHookDataModelProperties.CREATE_LANGUAGE_PROPERTIES");
        propertyNames.add("INewHookDataModelProperties.CUSTOM_JSPS_FOLDER");
        propertyNames.add("INewHookDataModelProperties.CUSTOM_JSPS_ITEMS");
        propertyNames.add("INewHookDataModelProperties.CUSTOM_JSPS_FILES_CREATED");
        propertyNames.add("INewHookDataModelProperties.PORTAL_PROPERTIES_FILE");
        propertyNames.add("INewHookDataModelProperties.PORTAL_PROPERTIES_ACTIONS_ITEMS");
        propertyNames.add("INewHookDataModelProperties.PORTAL_PROPERTIES_OVERRIDE_ITEMS");
        propertyNames.add("INewHookDataModelProperties.SERVICES_ITEMS");
        propertyNames.add("INewHookDataModelProperties.CONTENT_FOLDER");
        propertyNames.add("INewHookDataModelProperties.LANGUAGE_PROPERTIES_ITEMS");
        propertyNames.add("INewHookDataModelProperties.LANGUAGE_PROPERTIES_FILES_CREATED");
        propertyNames.add("NewJavaClassDataModel.SOURCE_FOLDER");
        propertyNames.add("NewJavaClassDataModel.JAVA_SOURCE_FOLDER");
        propertyNames.add("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        propertyNames.add("INewHookDataModelProperties.DISABLE_CUSTOM_JSP_FOLDER_VALIDATION");
        return propertyNames;
    }

    public void init() {
        super.init();
    }

    public IStatus validate(String propertyName) {
        if ("INewHookDataModelProperties.CUSTOM_JSPS_FOLDER".equals(propertyName) && this.getBooleanProperty("INewHookDataModelProperties.CREATE_CUSTOM_JSPS")) {
            String jspFolder = this.getStringProperty("INewHookDataModelProperties.CUSTOM_JSPS_FOLDER");
            if (CoreUtil.isNullOrEmpty((String)jspFolder)) {
                return HookCore.createErrorStatus(Msgs.customJSPsFolderNotConfigured);
            }
        } else {
            if ("INewHookDataModelProperties.CUSTOM_JSPS_ITEMS".equals(propertyName) && this.getBooleanProperty("INewHookDataModelProperties.CREATE_CUSTOM_JSPS")) {
                List jsps;
                Object jspItems = this.getProperty("INewHookDataModelProperties.CUSTOM_JSPS_ITEMS");
                if (jspItems instanceof List && (jsps = (List)jspItems).size() > 0) {
                    return Status.OK_STATUS;
                }
                return HookCore.createErrorStatus(Msgs.specifyOneJSP);
            }
            if ("INewHookDataModelProperties.PORTAL_PROPERTIES_FILE".equals(propertyName) && this.getBooleanProperty("INewHookDataModelProperties.CREATE_PORTAL_PROPERTIES")) {
                String portalPropertiesFile = this.getStringProperty("INewHookDataModelProperties.PORTAL_PROPERTIES_FILE");
                if (CoreUtil.isNullOrEmpty((String)portalPropertiesFile)) {
                    return HookCore.createErrorStatus(Msgs.portalPropertiesFileNotConfigured);
                }
            } else {
                if ("INewHookDataModelProperties.PORTAL_PROPERTIES_ACTIONS_ITEMS".equals(propertyName) && this.getBooleanProperty("INewHookDataModelProperties.CREATE_PORTAL_PROPERTIES")) {
                    IStatus actionItemsStatus = this.validateListItems("INewHookDataModelProperties.PORTAL_PROPERTIES_ACTIONS_ITEMS");
                    IStatus propertyOverridesStatus = this.validateListItems("INewHookDataModelProperties.PORTAL_PROPERTIES_OVERRIDE_ITEMS");
                    if (actionItemsStatus.isOK() || propertyOverridesStatus.isOK()) {
                        return Status.OK_STATUS;
                    }
                    return HookCore.createErrorStatus(Msgs.specifyOneEventActionProperty);
                }
                if ("INewHookDataModelProperties.SERVICES_ITEMS".equals(propertyName) && this.getBooleanProperty("INewHookDataModelProperties.CREATE_SERVICES")) {
                    IStatus itemsStatus = this.validateListItems("INewHookDataModelProperties.SERVICES_ITEMS");
                    if (itemsStatus.isOK()) {
                        return Status.OK_STATUS;
                    }
                    return HookCore.createErrorStatus(Msgs.specifyOneService);
                }
                if ("INewHookDataModelProperties.CONTENT_FOLDER".equals(propertyName) && this.getBooleanProperty("INewHookDataModelProperties.CREATE_LANGUAGE_PROPERTIES")) {
                    String contentFolder = this.getStringProperty("INewHookDataModelProperties.CONTENT_FOLDER");
                    if (CoreUtil.isNullOrEmpty((String)contentFolder)) {
                        return HookCore.createErrorStatus(Msgs.contentFolderNotConfigured);
                    }
                } else if ("INewHookDataModelProperties.LANGUAGE_PROPERTIES_ITEMS".equals(propertyName) && this.getBooleanProperty("INewHookDataModelProperties.CREATE_LANGUAGE_PROPERTIES")) {
                    List jsps;
                    Object propertiesItems = this.getProperty("INewHookDataModelProperties.LANGUAGE_PROPERTIES_ITEMS");
                    if (propertiesItems instanceof List && (jsps = (List)propertiesItems).size() > 0) {
                        return Status.OK_STATUS;
                    }
                    return HookCore.createErrorStatus(Msgs.specifyOneLanguagePropertyFile);
                }
            }
        }
        return super.validate(propertyName);
    }

    protected IFolder getDefaultJavaSourceFolder() {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources.length > 0) {
            try {
                return (IFolder)sources[0].getCorrespondingResource();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected IPackageFragmentRoot getJavaPackageFragmentRoot() {
        IFolder sourcefolder;
        IJavaProject aJavaProject;
        IProject project = this.getTargetProject();
        if (project != null && (aJavaProject = JemProjectUtilities.getJavaProject((IProject)project)) != null && (sourcefolder = (IFolder)this.getProperty("NewJavaClassDataModel.JAVA_SOURCE_FOLDER")) != null) {
            return aJavaProject.getPackageFragmentRoot((IResource)sourcefolder);
        }
        return null;
    }

    protected final IFolder getJavaSourceFolder() {
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)this.getTargetProject());
        if (sources == null || sources.length == 0) {
            return null;
        }
        String folderFullPath = this.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        int i = 0;
        while (i < sources.length) {
            if (sources[i].getPath().equals((Object)new Path(folderFullPath))) {
                try {
                    return (IFolder)sources[i].getCorrespondingResource();
                }
                catch (Exception exception) {
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    protected IStatus validateListItems(String propertyName) {
        List itemsList;
        Object items = this.getProperty(propertyName);
        if (items instanceof List && (itemsList = (List)items).size() > 0) {
            return Status.OK_STATUS;
        }
        return HookCore.createErrorStatus(Msgs.specifyOneItem);
    }

    private static class Msgs
    extends NLS {
        public static String contentFolderNotConfigured;
        public static String customJSPsFolderNotConfigured;
        public static String portalPropertiesFileNotConfigured;
        public static String specifyOneEventActionProperty;
        public static String specifyOneItem;
        public static String specifyOneJSP;
        public static String specifyOneLanguagePropertyFile;
        public static String specifyOneService;

        static {
            Msgs.initializeMessages((String)NewHookDataModelProvider.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

