/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.maven.core;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.maven.core.LiferayMavenCore;
import com.liferay.ide.maven.core.MavenProjectBuilder;
import com.liferay.ide.maven.core.MavenUtil;
import com.liferay.ide.project.core.BaseLiferayProject;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.server.util.ServerUtil;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.MavenJdtPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayMavenProject
extends BaseLiferayProject {
    public LiferayMavenProject(IProject project) {
        super(project);
    }

    public <T> T adapt(Class<T> adapterType) {
        Object adapter = super.adapt(adapterType);
        if (adapter != null) {
            return (T)adapter;
        }
        if (IProjectBuilder.class.equals(adapterType) && MavenUtil.getProjectFacade(this.getProject()) != null) {
            MavenProjectBuilder projectBuilder = new MavenProjectBuilder(this.getProject());
            return adapterType.cast((Object)projectBuilder);
        }
        return null;
    }

    public IPath getAppServerPortalDir() {
        Path retval = null;
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject());
        if (projectFacade != null) {
            try {
                MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                String appServerPortalDir = MavenUtil.getLiferayMavenPluginConfig(mavenProject, "appServerPortalDir");
                if (!CoreUtil.isNullOrEmpty((String)appServerPortalDir)) {
                    retval = new Path(appServerPortalDir);
                }
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public String[] getHookSupportedProperties() {
        String[] retval = null;
        this.getAppServerPortalDir();
        return retval;
    }

    public IPath getLibraryPath(String filename) {
        Object[] libs = this.getUserLibs();
        if (!CoreUtil.isNullOrEmpty((Object[])libs)) {
            Object[] objectArray = libs;
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                Object lib = objectArray[n2];
                if (lib.removeFileExtension().lastSegment().startsWith(filename)) {
                    return lib;
                }
                ++n2;
            }
        }
        return null;
    }

    public String getLiferayMavenPluginVersion() {
        MavenProject mavenProject;
        String retval = null;
        IMavenProjectFacade projectFacade = MavenPlugin.getMavenProjectRegistry().getProject(this.getProject());
        if (projectFacade != null && (mavenProject = projectFacade.getMavenProject()) != null) {
            Plugin liferayMavenPlugin = MavenUtil.getLiferayMavenPlugin(mavenProject);
            retval = liferayMavenPlugin.getVersion();
        }
        return retval;
    }

    public String getPortalVersion() {
        String retval = null;
        IMavenProjectFacade projectFacade = MavenUtil.getProjectFacade(this.getProject());
        if (projectFacade != null) {
            try {
                MavenProject mavenProject = projectFacade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                String liferayVersion = MavenUtil.getLiferayMavenPluginConfig(mavenProject, "liferayVersion");
                retval = MavenUtil.getVersion(liferayVersion);
            }
            catch (CoreException coreException) {}
        }
        return retval;
    }

    public Properties getPortletCategories() {
        Properties retval = null;
        IPath appServerPortalDir = this.getAppServerPortalDir();
        if (appServerPortalDir != null && appServerPortalDir.toFile().exists()) {
            retval = ServerUtil.getPortletCategories((IPath)appServerPortalDir);
        }
        return retval;
    }

    public Properties getPortletEntryCategories() {
        Properties retval = null;
        IPath appServerPortalDir = this.getAppServerPortalDir();
        if (appServerPortalDir != null && appServerPortalDir.toFile().exists()) {
            String portalVersion = null;
            ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
            if (liferayProject != null) {
                portalVersion = liferayProject.getPortalVersion();
            }
            retval = ServerUtil.getEntryCategories((IPath)appServerPortalDir, (String)portalVersion);
        }
        return retval;
    }

    public IPath[] getUserLibs() {
        ArrayList<IPath> libs = new ArrayList<IPath>();
        IClasspathManager buildPathManager = MavenJdtPlugin.getDefault().getBuildpathManager();
        try {
            IClasspathEntry[] classpath;
            IClasspathEntry[] iClasspathEntryArray = classpath = buildPathManager.getClasspath(this.getProject(), 1, true, (IProgressMonitor)new NullProgressMonitor());
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                libs.add(entry.getPath());
                ++n2;
            }
        }
        catch (CoreException e) {
            LiferayMavenCore.logError("Unable to get maven classpath.", e);
        }
        return libs.toArray(new IPath[0]);
    }
}

