/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.model;

import com.liferay.ide.core.model.IModel;
import com.liferay.ide.core.model.IModelChangeProviderExtension;
import com.liferay.ide.core.model.IModelChangedEvent;
import com.liferay.ide.core.model.IModelChangedListener;
import com.liferay.ide.core.model.IModelChangedListenerFilter;
import com.liferay.ide.core.model.ModelChangedEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.xml.sax.SAXException;

public abstract class AbstractModel
extends PlatformObject
implements IModel,
IModelChangeProviderExtension,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient List fListeners = Collections.synchronizedList(new ArrayList());
    private boolean fLoaded;
    protected boolean fDisposed;
    private long fTimestamp;
    private Exception fException;

    @Override
    public void addModelChangedListener(IModelChangedListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void transferListenersTo(IModelChangeProviderExtension target, IModelChangedListenerFilter filter) {
        ArrayList<IModelChangedListener> removed = new ArrayList<IModelChangedListener>();
        int i = 0;
        while (i < this.fListeners.size()) {
            IModelChangedListener listener = (IModelChangedListener)this.fListeners.get(i);
            if (filter == null || filter.accept(listener)) {
                target.addModelChangedListener(listener);
                removed.add(listener);
            }
            ++i;
        }
        this.fListeners.removeAll(removed);
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
    }

    @Override
    public void fireModelChanged(IModelChangedEvent event) {
        IModelChangedListener[] list = this.fListeners.toArray(new IModelChangedListener[this.fListeners.size()]);
        int i = 0;
        while (i < list.length) {
            IModelChangedListener listener = list[i];
            listener.modelChanged(event);
            ++i;
        }
    }

    @Override
    public void fireModelObjectChanged(Object object, String property, Object oldValue, Object newValue) {
        this.fireModelChanged(new ModelChangedEvent(this, object, property, oldValue, newValue));
    }

    @Override
    public String getResourceString(String key) {
        return key;
    }

    @Override
    public IResource getUnderlyingResource() {
        return null;
    }

    protected boolean isInSync(File localFile) {
        return localFile.exists() && localFile.lastModified() == this.getTimeStamp();
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed() && this.isLoaded();
    }

    @Override
    public final long getTimeStamp() {
        return this.fTimestamp;
    }

    protected abstract void updateTimeStamp();

    protected void updateTimeStamp(File localFile) {
        if (localFile.exists()) {
            this.fTimestamp = localFile.lastModified();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public boolean isLoaded() {
        return this.fLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.fLoaded = loaded;
    }

    public void setException(Exception e) {
        this.fException = e;
    }

    public Exception getException() {
        return this.fException;
    }

    @Override
    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fListeners.remove(listener);
    }

    public void throwParseErrorsException(Throwable e) throws CoreException {
        Status status = new Status(4, "com.liferay.ide.core", 0, "Error in the service file", e);
        throw new CoreException((IStatus)status);
    }

    protected SAXParser getSaxParser() throws ParserConfigurationException, SAXException, FactoryConfigurationError {
        return SAXParserFactory.newInstance().newSAXParser();
    }

    @Override
    public boolean isReconcilingModel() {
        return false;
    }
}

