/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileListing {
    public static IPath findFilePattern(File location, String pattern) {
        try {
            List<File> fileList = FileListing.getFileListing(location, false);
            for (File file : fileList) {
                if (!file.getPath().contains(pattern)) continue;
                File jreRoot = file.getParentFile().getParentFile();
                return new Path(jreRoot.getAbsolutePath());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return null;
    }

    public static List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            result.add(file);
            if (file.isFile()) continue;
            List<File> deeperList = FileListing.getFileListing(file);
            result.addAll(deeperList);
        }
        return result;
    }

    public static List<File> getFileListing(File aStartingDir, boolean sort) throws FileNotFoundException {
        FileListing.validateDirectory(aStartingDir);
        List<File> result = FileListing.getFileListing(aStartingDir);
        if (sort) {
            Collections.sort(result);
        }
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }
}

