/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core.util;

import com.liferay.ide.core.LiferayCore;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class MarkerUtil {
    public static void clearMarkers(IResource resource, String makerType, String sourceId) {
        if (resource.isAccessible()) {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers(makerType, true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    try {
                        if (sourceId == null || sourceId != null && marker.getAttribute("sourceId").equals(sourceId)) {
                            marker.delete();
                        }
                    }
                    catch (CoreException e) {
                        LiferayCore.logError("Unable to delete marker", e);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                LiferayCore.logError("Unable to find markers", e);
            }
        }
    }

    public static IMarker[] findMarkers(IResource resource, String markerType, String sourceId) {
        ArrayList<IMarker> retval = new ArrayList<IMarker>();
        try {
            if (resource.isAccessible()) {
                IMarker[] markers = resource.findMarkers(markerType, true, 2);
                if (sourceId != null) {
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        if (sourceId.equals(marker.getAttribute("sourceId", ""))) {
                            retval.add(marker);
                        }
                        ++n2;
                    }
                } else {
                    Collections.addAll(retval, markers);
                }
            }
        }
        catch (CoreException e) {
            LiferayCore.logError(e);
        }
        return retval.toArray(new IMarker[0]);
    }

    public static void setMarker(IResource resource, String markerType, int markerSeverity, String markerMsg, String markerLocation, String markerSourceId) throws CoreException {
        IMarker marker = resource.createMarker(markerType);
        marker.setAttribute("severity", markerSeverity);
        marker.setAttribute("message", (Object)markerMsg);
        marker.setAttribute("location", (Object)markerLocation);
        marker.setAttribute("sourceId", (Object)markerSourceId);
    }
}

