/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.workspace;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.gradle.core.workspace.ImportLiferayWorkspaceOp;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class ImportWorkspaceLocationValidationService
extends ValidationService {
    protected Status compute() {
        Status retval = Status.createOkStatus();
        try {
            if (LiferayWorkspaceUtil.hasLiferayWorkspace()) {
                retval = Status.createErrorStatus((String)LiferayWorkspaceUtil.hasLiferayWorkspaceMsg);
                return retval;
            }
        }
        catch (CoreException coreException) {
            retval = Status.createErrorStatus((String)LiferayWorkspaceUtil.multiWorkspaceError);
            return retval;
        }
        Path currentProjectLocation = (Path)this.op().getWorkspaceLocation().content(true);
        if (currentProjectLocation != null && !currentProjectLocation.isEmpty()) {
            String currentPath = currentProjectLocation.toOSString();
            retval = StatusBridge.create((IStatus)LiferayWorkspaceUtil.validateWorkspacePath((String)currentPath));
            if (!retval.ok()) {
                return retval;
            }
            String projectName = currentProjectLocation.lastSegment();
            if (CoreUtil.getProject((String)projectName).exists()) {
                retval = Status.createErrorStatus((String)"A project with that name already exists.");
                return retval;
            }
        }
        return retval;
    }

    private ImportLiferayWorkspaceOp op() {
        return (ImportLiferayWorkspaceOp)this.context(ImportLiferayWorkspaceOp.class);
    }
}

