/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.gradle.core.workspace;

import com.liferay.ide.gradle.core.workspace.NewLiferayWorkspaceOp;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class WorkspaceLocationValidationService
extends ValidationService {
    private Listener listener;

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        org.eclipse.sapphire.modeling.Path currentProjectLocation = (org.eclipse.sapphire.modeling.Path)this.op().getLocation().content(true);
        String currentWorkspaceName = (String)this.op().getWorkspaceName().content();
        if (!((Boolean)this.op().getUseDefaultLocation().content(true)).booleanValue() && currentWorkspaceName != null) {
            if (currentProjectLocation != null) {
                String currentPath = currentProjectLocation.toOSString();
                if (!Path.EMPTY.isValidPath(currentPath)) {
                    retval = Status.createErrorStatus((String)("\"" + currentPath + "\" is not a valid path."));
                } else {
                    IPath osPath = Path.fromOSString((String)currentPath);
                    if (!osPath.toFile().isAbsolute()) {
                        retval = Status.createErrorStatus((String)("\"" + currentPath + "\" is not an absolute path."));
                    } else if (!osPath.toFile().exists()) {
                        if (!this.canCreate(osPath.toFile())) {
                            retval = Status.createErrorStatus((String)("Cannot create project content at \"" + currentPath + "\""));
                        }
                    } else {
                        retval = Status.createErrorStatus((String)("There is already a folder at the location \"" + currentPath + "\""));
                    }
                }
            } else {
                retval = Status.createErrorStatus((String)"Location must be specified.");
            }
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.op().getWorkspaceName().detach(this.listener);
            this.listener = null;
        }
    }

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                WorkspaceLocationValidationService.this.refresh();
            }
        };
        this.op().getWorkspaceName().attach(this.listener);
    }

    private NewLiferayWorkspaceOp op() {
        return (NewLiferayWorkspaceOp)this.context(NewLiferayWorkspaceOp.class);
    }
}

