/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.eclipse.cp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ivyde.eclipse.IvyDEException;
import org.apache.ivyde.eclipse.cp.ResolvedPath;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class SettingsSetup {
    private String ivySettingsPath;
    private List propertyFiles = new ArrayList();
    private boolean loadSettingsOnDemand = false;
    private String ivyUserDir = "";

    public void set(SettingsSetup setup) {
        this.ivySettingsPath = setup.ivySettingsPath;
        this.propertyFiles = setup.propertyFiles;
        this.loadSettingsOnDemand = setup.loadSettingsOnDemand;
        this.ivyUserDir = setup.ivyUserDir;
    }

    public ResolvedPath getResolvedIvySettingsPath(IProject project) throws IvyDEException {
        return new ResolvedPath(this.ivySettingsPath, project);
    }

    public String getRawIvySettingsPath() {
        return this.ivySettingsPath;
    }

    public void setIvySettingsPath(String ivySettingsPath) {
        this.ivySettingsPath = ivySettingsPath;
    }

    public List getRawPropertyFiles() {
        return this.propertyFiles;
    }

    public List getResolvedPropertyFiles() throws IvyDEException {
        ArrayList<String> resolvedProps = new ArrayList<String>();
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            Iterator it = this.propertyFiles.iterator();
            while (it.hasNext()) {
                String propFile = (String)it.next();
                String resolvedProp = manager.performStringSubstitution(propFile, false);
                resolvedProps.add(resolvedProp);
            }
        }
        catch (CoreException e) {
            throw new IvyDEException("Unrecognized variables", "Unrecognized variables in the Ivy settings file " + this.ivySettingsPath, e);
        }
        return resolvedProps;
    }

    public void setPropertyFiles(List propertyFiles) {
        this.propertyFiles = propertyFiles;
    }

    public boolean isLoadSettingsOnDemand() {
        return this.loadSettingsOnDemand;
    }

    public void setLoadSettingsOnDemand(boolean loadSettingsOnDemand) {
        this.loadSettingsOnDemand = loadSettingsOnDemand;
    }

    public void setIvyUserDir(String ivyUserDir) {
        this.ivyUserDir = ivyUserDir;
    }

    public ResolvedPath getResolvedIvyUserDir(IProject project) throws IvyDEException {
        return new ResolvedPath(this.ivyUserDir, project);
    }

    public String getRawIvyUserDir() {
        return this.ivyUserDir;
    }
}

