/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.cpcontainer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;

public class IvyAttachementManager {
    private static final String SRC_SUFFIX = "-src";
    private static final String SRCROOT_SUFFIX = "-srcroot";
    private static final String DOC_SUFFIX = "-doc";
    private Properties prop = new Properties();
    private File containersAttachementFile;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IvyAttachementManager(File containersAttachementFile) {
        this.containersAttachementFile = containersAttachementFile;
        if (!containersAttachementFile.exists()) {
            IvyDEMessage.verbose("Attachement properties file not found: nothing to load");
            return;
        }
        IvyDEMessage.verbose("Reading attachement properties");
        try {
            FileInputStream in = new FileInputStream(containersAttachementFile);
            try {
                this.prop.load(in);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var3_6 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                in.close();
                return;
            }
        }
        catch (IOException ioe) {
            IvyPlugin.logWarn("IvyDE attachement properties could not be loaded", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAttchements(IJavaProject project, IPath containerPath, IClasspathContainer containerSuggestion) {
        IvyDEMessage.verbose("Updating attachements on the container " + containerPath);
        Properties newProps = new Properties();
        IClasspathEntry[] newEntries = containerSuggestion.getClasspathEntries();
        int i = 0;
        while (i < newEntries.length) {
            IClasspathEntry entry = newEntries[i];
            if (1 == entry.getEntryKind()) {
                String javadocUrl;
                String path = entry.getPath().toPortableString();
                if (entry.getSourceAttachmentPath() != null) {
                    newProps.put(String.valueOf(path) + SRC_SUFFIX, entry.getSourceAttachmentPath().toPortableString());
                }
                if (entry.getSourceAttachmentRootPath() != null) {
                    newProps.put(String.valueOf(path) + SRCROOT_SUFFIX, entry.getSourceAttachmentRootPath().toPortableString());
                }
                if ((javadocUrl = this.getJavadocLocation(entry)) != null) {
                    newProps.put(String.valueOf(path) + DOC_SUFFIX, javadocUrl);
                }
            }
            ++i;
        }
        IvyClasspathContainerImpl ivycp = (IvyClasspathContainerImpl)IvyClasspathContainerHelper.getContainer(containerPath, project);
        if (ivycp == null) {
            IvyDEMessage.error("The IvyDE container could not be found. Aborting updating attachements.");
            return;
        }
        IClasspathEntry[] existingEntries = ivycp.getClasspathEntries();
        int i2 = 0;
        while (i2 < existingEntries.length) {
            IClasspathEntry entry = existingEntries[i2];
            if (1 == entry.getEntryKind()) {
                String path = entry.getPath().toPortableString();
                String value = (String)this.prop.get(String.valueOf(path) + SRC_SUFFIX);
                if (value != null && entry.getSourceAttachmentPath() != null && value.equals(entry.getSourceAttachmentPath().toPortableString())) {
                    newProps.remove(String.valueOf(path) + SRC_SUFFIX);
                }
                if ((value = (String)this.prop.get(String.valueOf(path) + SRCROOT_SUFFIX)) != null && entry.getSourceAttachmentRootPath() != null && value.equals(entry.getSourceAttachmentRootPath().toPortableString())) {
                    newProps.remove(String.valueOf(path) + SRCROOT_SUFFIX);
                }
            }
            ++i2;
        }
        this.prop.putAll((Map<?, ?>)newProps);
        ivycp.updateClasspathEntries(newEntries);
        IvyDEMessage.verbose("Saving attachement properties");
        try {
            Object var9_13;
            FileOutputStream out = new FileOutputStream(this.containersAttachementFile);
            try {
                this.prop.store(out, "");
                var9_13 = null;
            }
            catch (Throwable throwable) {
                var9_13 = null;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            out.close();
            return;
        }
        catch (IOException ioe) {
            IvyPlugin.logWarn("IvyDE attachement properties could not be saved", ioe);
        }
    }

    public IPath getSourceAttachment(IPath path) {
        String srcPath = this.prop.getProperty(String.valueOf(path.toPortableString()) + SRC_SUFFIX);
        if (srcPath != null && srcPath.length() != 0) {
            return new Path(srcPath);
        }
        return null;
    }

    public IPath getSourceAttachmentRoot(IPath path) {
        String srcPath = this.prop.getProperty(String.valueOf(path.toPortableString()) + SRCROOT_SUFFIX);
        if (srcPath != null && srcPath.length() != 0) {
            return new Path(srcPath);
        }
        return null;
    }

    public URL getDocAttachment(IPath path) {
        String srcPath = this.prop.getProperty(String.valueOf(path.toPortableString()) + DOC_SUFFIX);
        if (srcPath != null && srcPath.length() != 0) {
            try {
                return new URL(srcPath);
            }
            catch (MalformedURLException e) {
                IvyPlugin.logWarn("The path for the doc attachement is not a valid URL", e);
                return null;
            }
        }
        return null;
    }

    public IPath getSourceAttachment(IPath classpathArtifact, IPath sourcesArtifact) {
        IPath sourceAttachment = this.getSourceAttachment(classpathArtifact);
        if (sourceAttachment == null) {
            sourceAttachment = sourcesArtifact;
        }
        return sourceAttachment;
    }

    public IPath getSourceAttachmentRoot(IPath classpathArtifact, IPath sourcesArtifact) {
        IPath sourceAttachment = this.getSourceAttachmentRoot(classpathArtifact);
        if (sourceAttachment == null && sourcesArtifact != null) {
            sourceAttachment = sourcesArtifact;
        }
        return sourceAttachment;
    }

    public String getJavadocLocation(IClasspathEntry entry) {
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        int j = 0;
        while (j < attributes.length) {
            IClasspathAttribute attribute = attributes[j];
            if ("javadoc_location".equals(attribute.getName())) {
                return attribute.getValue();
            }
            ++j;
        }
        return null;
    }
}

