/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.resolve;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.filter.ArtifactTypeFilter;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathUtil;
import org.apache.ivyde.internal.eclipse.resolve.IvyResolveJobListener;
import org.apache.ivyde.internal.eclipse.resolve.RefreshFolderJob;
import org.apache.ivyde.internal.eclipse.resolve.ResolveResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class IvyResolver {
    private boolean usePreviousResolveIfExist = false;
    private String[] confs;
    private final IProject project;
    private final List confInput;
    private String retrievePattern = null;
    private boolean retrieveSync = true;
    private String retrieveTypes = null;
    private final String ivyXmlPath;
    private boolean useCacheOnly = IvyPlugin.getPreferenceStoreHelper().isOffline();
    private boolean useExtendedResolveId = false;
    private boolean transitiveResolve = true;
    static /* synthetic */ Class class$0;

    public IvyResolver(String ivyXmlPath, List confInput, IProject project) {
        this.ivyXmlPath = ivyXmlPath;
        this.confInput = confInput;
        this.project = project;
    }

    public void setUsePreviousResolveIfExist(boolean usePreviousResolveIfExist) {
        this.usePreviousResolveIfExist = usePreviousResolveIfExist;
    }

    public void setRetrievePattern(String retrievePattern) {
        this.retrievePattern = retrievePattern;
    }

    public void setRetrieveSync(boolean retrieveSync) {
        this.retrieveSync = retrieveSync;
    }

    public void setRetrieveTypes(String retrieveTypes) {
        this.retrieveTypes = retrieveTypes;
    }

    public void setUseCacheOnly(boolean useCacheOnly) {
        this.useCacheOnly = useCacheOnly;
    }

    public void setTransitiveResolve(boolean transitiveResolve) {
        this.transitiveResolve = transitiveResolve;
    }

    public String getIvyXmlPath() {
        return this.ivyXmlPath;
    }

    public IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus resolve(Ivy ivy, ModuleDescriptor md, IProgressMonitor monitor, int step) {
        block20: {
            block19: {
                this.computeConfs(this.confInput, md);
                try {
                    try {
                        ivy.pushContext();
                        IvyDEMessage.info("Resolving " + this.toString());
                        ivyResolveJobListener = new IvyResolveJobListener(monitor, step);
                        ivy.getEventManager().addIvyListener((IvyListener)ivyResolveJobListener);
                        monitor.setTaskName("Resolve of " + this.toString());
                        result = new ResolveResult();
                        old = Thread.currentThread().getContextClassLoader();
                        v0 = Thread.currentThread();
                        v1 = IvyResolver.class$0;
                        if (v1 == null) {
                            try {
                                v2 = Class.forName("org.apache.ivyde.internal.eclipse.resolve.IvyResolver");
                            }
                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                            v1 = IvyResolver.class$0 = v2;
                        }
                        v0.setContextClassLoader(v1.getClassLoader());
                        try {
                            result = this.usePreviousResolveIfExist != false ? this.resolveWithPrevious(ivy, md) : this.doResolve(ivy, md);
                            if (!result.getProblemMessages().isEmpty()) ** GOTO lbl-1000
                            retrieveStatus = this.maybeRetrieve(ivy, md, result, monitor);
                            if (retrieveStatus.isOK()) ** GOTO lbl-1000
                            var12_12 = retrieveStatus;
                            var10_15 = null;
                            Thread.currentThread().setContextClassLoader(old);
                            ** GOTO lbl58
                        }
                        catch (ParseException e) {
                            errorMsg = "Error while parsing the ivy file from " + this.toString() + "\n" + e.getMessage();
                            IvyDEMessage.error(errorMsg);
                            var12_13 = new Status(4, "org.apache.ivyde.eclipse", 4, errorMsg, (Throwable)e);
                            var10_16 = null;
                            Thread.currentThread().setContextClassLoader(old);
                            ivy.getEventManager().removeIvyListener((IvyListener)ivyResolveJobListener);
                            var13_21 = null;
                            ivy.popContext();
                            return var12_13;
                        }
                        catch (Exception e) {
                            try {
                                errorMsg = "Error while resolving dependencies for " + this.toString() + "\n" + e.getMessage();
                                IvyDEMessage.error(errorMsg);
                                var12_14 = new Status(4, "org.apache.ivyde.eclipse", 4, errorMsg, (Throwable)e);
                                var10_17 = null;
                                Thread.currentThread().setContextClassLoader(old);
                                ** GOTO lbl64
                            }
                            catch (Throwable var11_30) {
                                var10_18 = null;
                                Thread.currentThread().setContextClassLoader(old);
                                ivy.getEventManager().removeIvyListener((IvyListener)ivyResolveJobListener);
                                throw var11_30;
lbl58:
                                // 1 sources

                                ivy.getEventManager().removeIvyListener((IvyListener)ivyResolveJobListener);
                                var13_20 = null;
                                break block19;
lbl-1000:
                                // 1 sources

                                {
                                    this.postResolveOrRefresh(ivy, md, result, monitor);
                                    ** GOTO lbl-1000
                                }
lbl64:
                                // 1 sources

                                ivy.getEventManager().removeIvyListener((IvyListener)ivyResolveJobListener);
                                var13_22 = null;
                                ivy.popContext();
                                return var12_14;
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            var10_19 = null;
                            Thread.currentThread().setContextClassLoader(old);
                        }
                        ivy.getEventManager().removeIvyListener((IvyListener)ivyResolveJobListener);
                        if (!result.getProblemMessages().isEmpty()) {
                            multiStatus = new MultiStatus("org.apache.ivyde.eclipse", 4, "Impossible to resolve dependencies of " + md.getModuleRevisionId(), null);
                            iter = result.getProblemMessages().iterator();
                            while (true) {
                                if (!iter.hasNext()) break;
                                multiStatus.add((IStatus)new Status(4, "org.apache.ivyde.eclipse", 4, (String)iter.next(), null));
                            }
                            var15_31 = multiStatus;
                            var13_23 = null;
                            ivy.popContext();
                            return var15_31;
                        }
                        var15_32 = Status.OK_STATUS;
                        break block20;
                    }
                    catch (Throwable e) {
                        var15_33 = new Status(4, "org.apache.ivyde.eclipse", 4, "The resolve job of " + this.toString() + " has unexpectedly stopped", e);
                        var13_25 = null;
                        ivy.popContext();
                        return var15_33;
                    }
                }
                catch (Throwable var14_34) {
                    var13_26 = null;
                    ivy.popContext();
                    throw var14_34;
                }
            }
            ivy.popContext();
            return var12_12;
        }
        var13_24 = null;
        ivy.popContext();
        return var15_32;
    }

    protected void postResolveOrRefresh(Ivy ivy, ModuleDescriptor md, ResolveResult resolveResult, IProgressMonitor monitor) throws IOException {
    }

    private void computeConfs(List confInput, ModuleDescriptor md) {
        HashSet configurations = new HashSet();
        configurations.addAll(confInput);
        this.confs = configurations.contains("*") ? md.getConfigurationsNames() : configurations.toArray(new String[configurations.size()]);
    }

    private ResolveResult resolveWithPrevious(Ivy ivy, ModuleDescriptor md) throws ParseException, IOException {
        IvyDEMessage.verbose("Trying to read previous resolve report");
        ResolveResult result = new ResolveResult();
        int i = 0;
        while (i < this.confs.length) {
            IvyDEMessage.verbose("Fetching the resolve report for configuration " + this.confs[i]);
            File report = ivy.getResolutionCacheManager().getConfigurationResolveReportInCache(IvyClasspathUtil.buildResolveId(this.useExtendedResolveId, md), this.confs[i]);
            IvyDEMessage.debug("Cheking resolve report at " + report);
            if (!report.exists()) {
                IvyDEMessage.info("The resolve report for the configuration " + this.confs[i] + " was not found. Falling back by doing a resolve again.");
                return this.doResolve(ivy, md);
            }
            IvyDEMessage.verbose("Resolve report found, parsing it");
            try {
                XmlReportParser parser = new XmlReportParser();
                parser.parse(report);
                result.addArtifactReports(parser.getArtifactReports());
                this.findAllArtifactOnRefresh(ivy, parser, result);
            }
            catch (ParseException parseException) {
                IvyDEMessage.info("Error while parsing the report " + report + ". Falling back by doing a resolve again.");
                return this.doResolve(ivy, md);
            }
            ++i;
        }
        return result;
    }

    private ResolveResult doResolve(Ivy ivy, ModuleDescriptor md) throws ParseException, IOException {
        IvyDEMessage.debug("Doing a full resolve...");
        ResolveOptions resolveOption = new ResolveOptions();
        resolveOption.setConfs(this.confs);
        resolveOption.setValidate(ivy.getSettings().doValidate());
        resolveOption.setUseCacheOnly(this.useCacheOnly);
        resolveOption.setResolveId(IvyClasspathUtil.buildResolveId(this.useExtendedResolveId, md));
        resolveOption.setTransitive(this.transitiveResolve);
        ResolveReport report = ivy.getResolveEngine().resolve(md, resolveOption);
        if (report.hasError()) {
            IvyDEMessage.verbose("Resolve ended with errors");
        } else {
            IvyDEMessage.verbose("Resolve successful");
        }
        ResolveResult result = new ResolveResult(report);
        ArtifactDownloadReport[] artifactReports = report.getArtifactsReports(null, false);
        Map workspaceArtifacts = (Map)IvyContext.getContext().get("IvyDEWorkspaceArtifactReports");
        if (workspaceArtifacts != null) {
            int i = 0;
            while (i < artifactReports.length) {
                ArtifactDownloadReport eclipseArtifactReport = (ArtifactDownloadReport)workspaceArtifacts.get(artifactReports[i].getArtifact());
                if (eclipseArtifactReport != null) {
                    artifactReports[i] = eclipseArtifactReport;
                }
                ++i;
            }
        }
        result.addArtifactReports(artifactReports);
        this.collectArtifactsByDependency(report, result);
        return result;
    }

    private void findAllArtifactOnRefresh(Ivy ivy, XmlReportParser parser, ResolveResult result) throws ParseException {
        ModuleRevisionId[] dependencyMrdis = parser.getDependencyRevisionIds();
        IvyDEMessage.verbose("Resolve report parsed. Fetching artifacts of " + dependencyMrdis.length + " dependencie(s)");
        int iDep = 0;
        while (iDep < dependencyMrdis.length) {
            DependencyResolver depResolver = ivy.getSettings().getResolver(dependencyMrdis[iDep]);
            DefaultDependencyDescriptor depDescriptor = new DefaultDependencyDescriptor(dependencyMrdis[iDep], false);
            ResolveOptions options = new ResolveOptions();
            options.setRefresh(true);
            options.setUseCacheOnly(true);
            IvyDEMessage.debug("Fetching dependency " + dependencyMrdis[iDep]);
            ResolvedModuleRevision dependency = depResolver.getDependency((DependencyDescriptor)depDescriptor, new ResolveData(ivy.getResolveEngine(), options));
            if (dependency != null) {
                Artifact[] artifacts = dependency.getDescriptor().getAllArtifacts();
                IvyDEMessage.debug("Dependency " + dependencyMrdis[iDep] + " found: " + artifacts.length + " artifact(s) found");
                result.putArtifactsForDep(dependencyMrdis[iDep], artifacts);
            } else {
                IvyDEMessage.debug("Dependency " + dependencyMrdis[iDep] + " not found");
            }
            ++iDep;
        }
    }

    private void collectArtifactsByDependency(ResolveReport r, ResolveResult result) {
        Iterator it = r.getDependencies().iterator();
        while (it.hasNext()) {
            IvyNode node = (IvyNode)it.next();
            if (node.getDescriptor() == null) continue;
            result.putArtifactsForDep(node.getResolvedId(), node.getDescriptor().getAllArtifacts());
        }
    }

    private IStatus maybeRetrieve(Ivy ivy, ModuleDescriptor md, ResolveResult result, IProgressMonitor monitor) throws IOException {
        String pattern;
        if (this.retrievePattern == null || this.project == null) {
            IvyDEMessage.debug("No file retrieving configured");
            return Status.OK_STATUS;
        }
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            pattern = varManager.performStringSubstitution(this.retrievePattern, false);
        }
        catch (CoreException e) {
            return new Status(4, "org.apache.ivyde.eclipse", 4, "Incorrect use of variables in retrievePattern '" + this.retrievePattern + "'." + e.getMessage(), (Throwable)e);
        }
        if (!this.retrievePattern.startsWith("${")) {
            pattern = String.valueOf(this.project.getLocation().toPortableString()) + "/" + pattern;
        }
        IvyDEMessage.info("Retrieving files into " + pattern);
        monitor.setTaskName("retrieving dependencies in " + pattern);
        RetrieveOptions options = new RetrieveOptions();
        options.setSync(this.retrieveSync);
        if (!result.isPreviousUsed()) {
            options.setResolveId(result.getReport().getResolveId());
        }
        options.setConfs(this.confs);
        if (this.retrieveTypes != null && !this.retrieveTypes.equals("*")) {
            List typeList = IvyClasspathUtil.split(this.retrieveTypes);
            options.setArtifactFilter((Filter)new ArtifactTypeFilter((Collection)typeList));
        }
        options.setResolveId(IvyClasspathUtil.buildResolveId(this.useExtendedResolveId, md));
        String refreshPath = IvyPatternHelper.getTokenRoot((String)this.retrievePattern);
        if (this.retrieveSync && refreshPath.length() == 0) {
            return new Status(4, "org.apache.ivyde.eclipse", 4, "The root of the retrieve pattern is the root folder of the project. Your project would have then been entirely deleted. Change your retrieve pattern to have a sub folder.", null);
        }
        int numberOfItemsRetrieved = ivy.retrieve(md.getModuleRevisionId(), pattern, options);
        IvyDEMessage.info(String.valueOf(numberOfItemsRetrieved) + " retrieved file(s)");
        if (numberOfItemsRetrieved > 0) {
            IProject retrieveFolder;
            if (refreshPath.length() == 0) {
                retrieveFolder = this.project;
                IvyDEMessage.verbose("Refreshing Eclipse project " + this.project.getName());
            } else {
                retrieveFolder = this.project.getFolder(refreshPath);
                IvyDEMessage.verbose("Refreshing Eclipse folder " + retrieveFolder);
            }
            RefreshFolderJob refreshFolderJob = new RefreshFolderJob((IResource)retrieveFolder);
            refreshFolderJob.schedule();
        }
        String resolvedPattern = IvyPatternHelper.substituteVariables((String)pattern, (IvyVariableContainer)ivy.getSettings().getVariables());
        try {
            Map retrievedArtifacts = ivy.getRetrieveEngine().determineArtifactsToCopy(md.getModuleRevisionId(), resolvedPattern, options);
            result.setRetrievedArtifacts(retrievedArtifacts);
        }
        catch (ParseException e) {
            return new Status(4, "org.apache.ivyde.eclipse", 4, "failed to parse a resolve report in order to do the retrieve", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public void postBatchResolve() {
    }

    public String toString() {
        return String.valueOf(this.ivyXmlPath) + this.confInput + (this.project == null ? "" : " in " + this.project.getName());
    }
}

