/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.revdepexplorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivyde.eclipse.cp.IvyClasspathContainerHelper;
import org.apache.ivyde.internal.eclipse.cpcontainer.IvyClasspathContainerImpl;
import org.apache.ivyde.internal.eclipse.revdepexplorer.MultiRevDependencyDescriptor;
import org.eclipse.core.resources.IProject;

public final class IvyUtil {
    private IvyUtil() {
    }

    public static MultiRevDependencyDescriptor[] getDependencyDescriptorsByProjects(IProject[] projects) {
        HashMap<ModuleId, MultiRevDependencyDescriptor> mdMap = new HashMap<ModuleId, MultiRevDependencyDescriptor>();
        int i = 0;
        while (i < projects.length) {
            List containers = IvyClasspathContainerHelper.getContainers(projects[i]);
            Iterator containerIter = containers.iterator();
            while (containerIter.hasNext()) {
                IvyClasspathContainerImpl container = (IvyClasspathContainerImpl)containerIter.next();
                ModuleDescriptor md = container.getState().getCachedModuleDescriptor();
                if (md == null) continue;
                DependencyDescriptor[] descriptors = md.getDependencies();
                int j = 0;
                while (j < descriptors.length) {
                    DependencyDescriptor descriptor = descriptors[j];
                    MultiRevDependencyDescriptor syncabledd = (MultiRevDependencyDescriptor)mdMap.get(descriptor.getDependencyId());
                    if (syncabledd == null) {
                        syncabledd = new MultiRevDependencyDescriptor(descriptor.getDependencyId());
                        mdMap.put(descriptor.getDependencyId(), syncabledd);
                    }
                    syncabledd.addDependencyDescriptor(container, descriptor);
                    ++j;
                }
            }
            ++i;
        }
        ArrayList sorted = new ArrayList(mdMap.values());
        Collections.sort(sorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                MultiRevDependencyDescriptor desc1 = (MultiRevDependencyDescriptor)o1;
                MultiRevDependencyDescriptor desc2 = (MultiRevDependencyDescriptor)o2;
                int equal = desc1.getOrganization().compareTo(desc2.getOrganization());
                if (equal == 0) {
                    equal = desc1.getModule().compareTo(desc2.getModule());
                }
                return equal;
            }
        });
        return sorted.toArray(new MultiRevDependencyDescriptor[sorted.size()]);
    }

    public static MultiRevDependencyDescriptor[] getAllDependencyDescriptorsInWorkspace() {
        return IvyUtil.getDependencyDescriptorsByProjects(IvyClasspathContainerHelper.getIvyProjectsInWorkspace());
    }
}

