/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.editors.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    private Map fKeyTable = new HashMap();
    private Map fDisplayTable = new HashMap();

    public void dispose(Display display) {
        Map colorTable = (Map)this.fDisplayTable.get(display);
        if (colorTable != null) {
            Iterator e = colorTable.values().iterator();
            while (e.hasNext()) {
                Color color = (Color)e.next();
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        HashMap<RGB, Color> colorTable = (HashMap<RGB, Color>)this.fDisplayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>();
            this.fDisplayTable.put(display, colorTable);
            display.disposeExec(new Runnable(){

                public void run() {
                    ColorManager.this.dispose(display);
                }
            });
        }
        if ((color = (Color)colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = (RGB)this.fKeyTable.get(key);
        return this.getColor(rgb);
    }

    public void bindColor(String key, RGB rgb) {
        Object value = this.fKeyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.fKeyTable.put(key, rgb);
    }

    public void unbindColor(String key) {
        this.fKeyTable.remove(key);
    }

    public void refreshFromStore(IPreferenceStore store) {
        this.rebind(store, "editor.color.xmlComment");
        this.rebind(store, "editor.color.procInstr");
        this.rebind(store, "editor.color.string");
        this.rebind(store, "editor.color.default");
        this.rebind(store, "editor.color.tag");
    }

    private void rebind(IPreferenceStore store, String colorId) {
        this.unbindColor(colorId);
        this.bindColor(colorId, PreferenceConverter.getColor((IPreferenceStore)store, (String)colorId));
    }
}

