/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.menu;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivyde.internal.eclipse.IvyDEMessage;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CleanCacheAction
extends Action {
    private final List cleanables;
    private final String name;

    public CleanCacheAction(String name, List cleanables) {
        this.name = name;
        this.cleanables = cleanables;
    }

    public void run() {
        final boolean[] ok = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ok[0] = MessageDialog.openConfirm((Shell)IvyPlugin.getActiveWorkbenchShell(), (String)CleanCacheAction.this.name, (String)("Are you sure you want to " + CleanCacheAction.this.name.toLowerCase(Locale.US) + ". (cannot be undone)"));
            }
        });
        if (ok[0]) {
            Iterator itCleanable = this.cleanables.iterator();
            while (itCleanable.hasNext()) {
                Cleanable cleanable = (Cleanable)itCleanable.next();
                cleanable.launchClean();
                IvyDEMessage.info("Ivy cache cleaned: " + cleanable.getName());
            }
        }
    }

    public static abstract class Cleanable {
        public void launchClean() {
            Job cleanJob = new Job(this, "Cleaning cache " + this.getName()){
                final /* synthetic */ Cleanable this$1;
                {
                    this.this$1 = cleanable;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    this.this$1.clean();
                    return Status.OK_STATUS;
                }
            };
            cleanJob.setUser(true);
            cleanJob.schedule();
        }

        protected abstract void clean();

        public abstract String getName();
    }

    public static class RepositoryCacheCleanable
    extends Cleanable {
        private final RepositoryCacheManager manager;

        public RepositoryCacheCleanable(RepositoryCacheManager manager) {
            this.manager = manager;
        }

        protected void clean() {
            this.manager.clean();
        }

        public String getName() {
            return this.manager.getName();
        }
    }

    public static class ResolutionCacheCleanable
    extends Cleanable {
        private final ResolutionCacheManager manager;

        public ResolutionCacheCleanable(ResolutionCacheManager manager) {
            this.manager = manager;
        }

        protected void clean() {
            this.manager.clean();
        }

        public String getName() {
            return "resolution";
        }
    }
}

