/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.preferences;

import org.apache.ivyde.internal.eclipse.retrieve.StandaloneRetrieveSetup;
import org.apache.ivyde.internal.eclipse.ui.IvyFilePathText;
import org.apache.ivyde.internal.eclipse.ui.RetrieveComposite;
import org.apache.ivyde.internal.eclipse.ui.SettingsSetupTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class EditStandaloneRetrieveDialog
extends Dialog {
    private final IProject project;
    private Text nameText;
    private StandaloneRetrieveSetup retrieveSetup;
    private IvyFilePathText ivyFilePathText;
    private RetrieveComposite retrieveComposite;
    private SettingsSetupTab settingsTab;
    private StandaloneRetrieveSetup setup;
    private Button resolveInWorkspaceCheck;

    protected EditStandaloneRetrieveDialog(Shell parentShell, IProject project, StandaloneRetrieveSetup retrieveSetup) {
        super(parentShell);
        this.project = project;
        this.retrieveSetup = retrieveSetup;
    }

    protected Control createDialogArea(Composite parent) {
        TabFolder tabs = new TabFolder(parent, 2048);
        TabItem mainTab = new TabItem(tabs, 0);
        mainTab.setText("Main");
        mainTab.setControl(this.createMainTab((Composite)tabs));
        this.settingsTab = new SettingsSetupTab(tabs, this.project){

            protected void settingsUpdated() {
                super.settingsUpdated();
            }
        };
        this.nameText.setText(this.retrieveSetup.getName());
        this.settingsTab.init(this.retrieveSetup.isSettingProjectSpecific(), this.retrieveSetup.getSettingsSetup());
        this.ivyFilePathText.init(this.retrieveSetup.getIvyXmlPath());
        this.retrieveComposite.init(this.retrieveSetup.getRetrieveSetup());
        this.resolveInWorkspaceCheck.setSelection(this.retrieveSetup.isResolveInWorkspace());
        return tabs;
    }

    private Control createMainTab(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        Composite nameComposite = new Composite(body, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(nameComposite, 0);
        nameLabel.setText("Name: ");
        nameLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.nameText = new Text(nameComposite, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite ivyFileComposite = new Composite(body, 0);
        ivyFileComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        ivyFileComposite.setLayout((Layout)new GridLayout(2, false));
        this.ivyFilePathText = new IvyFilePathText(ivyFileComposite, 0, this.project);
        this.ivyFilePathText.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        this.resolveInWorkspaceCheck = new Button(body, 32);
        this.resolveInWorkspaceCheck.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.resolveInWorkspaceCheck.setText("Resolve dependencies in workspace");
        this.resolveInWorkspaceCheck.setToolTipText("Will replace jars on the classpath with workspace projects");
        this.retrieveComposite = new RetrieveComposite(body, 0, true, this.project);
        this.retrieveComposite.setLayoutData(new GridData(4, 4, true, false));
        return body;
    }

    protected void okPressed() {
        this.setup = new StandaloneRetrieveSetup();
        this.setup.setName(this.nameText.getText());
        this.setup.setSettingsProjectSpecific(this.settingsTab.isProjectSpecific());
        this.setup.setSettingsSetup(this.settingsTab.getSettingsEditor().getIvySettingsSetup());
        this.setup.setIvyXmlPath(this.ivyFilePathText.getIvyFilePath());
        this.setup.setRetrieveSetup(this.retrieveComposite.getRetrieveSetup());
        this.setup.setResolveInWorkspace(this.resolveInWorkspaceCheck.getSelection());
        super.okPressed();
    }

    public StandaloneRetrieveSetup getStandaloneRetrieveSetup() {
        return this.setup;
    }
}

