/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.ui.preferences;

import org.apache.ivy.Ivy;
import org.apache.ivyde.internal.eclipse.IvyPlugin;
import org.apache.ivyde.internal.eclipse.ui.preferences.IvyDEPreferenceStoreHelper;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class IvyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PEREFERENCE_PAGE_ID = "org.apache.ivyde.eclipse.ui.preferences.IvyPreferencePage";
    private Text organizationText;
    private Text organizationUrlText;
    private Button refreshOnStartupButton;
    private Button resolveOnStartupButton;
    private Button doNothingOnStartupButton;
    private Button openIvyConsoleOnStartupButton;
    private Button resolveOnChangeButton;
    private Button doNothingOnChangeButton;
    private Button offlineButton;
    private Button errorPopupButton;

    public IvyPreferencePage() {
        this.setPreferenceStore(IvyPlugin.getDefault().getPreferenceStore());
        Object ivydeVersion = IvyPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
        this.setDescription("Ivy " + Ivy.getIvyVersion() + " (" + Ivy.getIvyDate() + ")  --  IvyDE " + ivydeVersion);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(IvyPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout());
        Label horizontalLine = new Label(composite, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false));
        this.offlineButton = new Button(composite, 32);
        this.offlineButton.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.offlineButton.setText("Offline (use only the caches)");
        this.openIvyConsoleOnStartupButton = new Button(composite, 32);
        this.openIvyConsoleOnStartupButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.openIvyConsoleOnStartupButton.setText("Open the Ivy console on startup");
        Group startupGroup = new Group(composite, 0);
        startupGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        startupGroup.setLayout((Layout)new GridLayout());
        startupGroup.setText("On Eclipse startup");
        this.doNothingOnStartupButton = new Button((Composite)startupGroup, 16);
        this.doNothingOnStartupButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.doNothingOnStartupButton.setText("Do nothing");
        this.refreshOnStartupButton = new Button((Composite)startupGroup, 16);
        this.refreshOnStartupButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.refreshOnStartupButton.setText("Trigger refresh");
        this.resolveOnStartupButton = new Button((Composite)startupGroup, 16);
        this.resolveOnStartupButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.resolveOnStartupButton.setText("Trigger resolve");
        Group fileChangeGroup = new Group(composite, 0);
        fileChangeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        fileChangeGroup.setLayout((Layout)new GridLayout());
        fileChangeGroup.setText("On Ivy File Change");
        this.doNothingOnChangeButton = new Button((Composite)fileChangeGroup, 16);
        this.doNothingOnChangeButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.doNothingOnChangeButton.setText("Do nothing");
        this.resolveOnChangeButton = new Button((Composite)fileChangeGroup, 16);
        this.resolveOnChangeButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.resolveOnChangeButton.setText("Trigger resolve");
        Group editorGroup = new Group(composite, 0);
        editorGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        editorGroup.setLayout((Layout)new GridLayout(2, false));
        editorGroup.setText("Editor information");
        Label label = new Label((Composite)editorGroup, 0);
        label.setText("Organisation:");
        this.organizationText = new Text((Composite)editorGroup, 2052);
        this.organizationText.setLayoutData((Object)new GridData(4, 1, true, false));
        label = new Label((Composite)editorGroup, 0);
        label.setText("Organisation URL:");
        this.organizationUrlText = new Text((Composite)editorGroup, 2052);
        this.organizationUrlText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.errorPopupButton = new Button(composite, 32);
        this.errorPopupButton.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.errorPopupButton.setText("Open a popup on each failed resolve");
        this.initPreferences();
        return composite;
    }

    private void initPreferences() {
        IvyDEPreferenceStoreHelper helper = IvyPlugin.getPreferenceStoreHelper();
        switch (helper.getResolveOnStartup()) {
            case 0: {
                this.doNothingOnStartupButton.setSelection(true);
                break;
            }
            case 1: {
                this.refreshOnStartupButton.setSelection(true);
                break;
            }
            case 2: {
                this.resolveOnStartupButton.setSelection(true);
                break;
            }
            default: {
                IvyPlugin.logWarn("Unkwnon resolve-on-startup mode: " + helper.getResolveOnStartup());
            }
        }
        if (helper.getAutoResolveOnChange()) {
            this.resolveOnChangeButton.setSelection(true);
        } else {
            this.doNothingOnChangeButton.setSelection(true);
        }
        this.openIvyConsoleOnStartupButton.setSelection(helper.isOpenIvyConsoleOnStartup());
        this.organizationText.setText(helper.getIvyOrg());
        this.organizationUrlText.setText(helper.getIvyOrgUrl());
        this.offlineButton.setSelection(helper.isOffline());
        this.errorPopupButton.setSelection(helper.isErrorPopup());
    }

    public boolean performOk() {
        IvyDEPreferenceStoreHelper helper = IvyPlugin.getPreferenceStoreHelper();
        if (this.doNothingOnStartupButton.getSelection()) {
            helper.setResolveOnStartup(0);
        } else if (this.refreshOnStartupButton.getSelection()) {
            helper.setResolveOnStartup(1);
        } else {
            helper.setResolveOnStartup(2);
        }
        if (this.resolveOnChangeButton.getSelection()) {
            helper.setAutoResolveOnChange(true);
        } else {
            helper.setAutoResolveOnChange(false);
        }
        helper.setOpenIvyConsoleOnStartup(this.openIvyConsoleOnStartupButton.getSelection());
        helper.setOrganization(this.organizationText.getText());
        helper.setOrganizationUrl(this.organizationUrlText.getText());
        helper.setOffline(this.offlineButton.getSelection());
        helper.setErrorPopup(this.errorPopupButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        switch (0) {
            case 0: {
                this.doNothingOnStartupButton.setSelection(true);
                break;
            }
            case 1: {
                this.refreshOnStartupButton.setSelection(true);
                break;
            }
            case 2: {
                this.resolveOnStartupButton.setSelection(true);
                break;
            }
            default: {
                IvyPlugin.logWarn("Unkwnon resolve-on-startup mode: 0");
            }
        }
        this.resolveOnChangeButton.setSelection(true);
        this.openIvyConsoleOnStartupButton.setSelection(false);
        this.organizationText.setText("");
        this.organizationUrlText.setText("");
        this.offlineButton.setSelection(false);
        this.errorPopupButton.setSelection(true);
    }
}

