/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivyde.internal.eclipse.workspaceresolver;

import java.util.Comparator;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class IvyDEStrategy
extends ComparatorLatestStrategy {
    private final Comparator mridComparator = new MridComparator();
    private final Comparator artifactInfoComparator = new ArtifactInfoComparator();

    public IvyDEStrategy() {
        this.setComparator(this.artifactInfoComparator);
        this.setName("ivyde-latest-revision");
    }

    final class ArtifactInfoComparator
    implements Comparator {
        ArtifactInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            String rev1 = ((ArtifactInfo)o1).getRevision();
            String rev2 = ((ArtifactInfo)o2).getRevision();
            VersionMatcher vmatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            ModuleRevisionId mrid1 = ModuleRevisionId.newInstance((String)"", (String)"", (String)rev1);
            ModuleRevisionId mrid2 = ModuleRevisionId.newInstance((String)"", (String)"", (String)rev2);
            if (vmatcher.isDynamic(mrid1)) {
                int c = vmatcher.compare(mrid1, mrid2, IvyDEStrategy.this.mridComparator);
                return c >= 0 ? 1 : -1;
            }
            if (vmatcher.isDynamic(mrid2)) {
                int c = vmatcher.compare(mrid2, mrid1, IvyDEStrategy.this.mridComparator);
                return c >= 0 ? -1 : 1;
            }
            return IvyDEStrategy.this.mridComparator.compare(mrid1, mrid2);
        }
    }

    final class MridComparator
    implements Comparator {
        MridComparator() {
        }

        public int compare(Object o1, Object o2) {
            boolean latestRev2;
            String rev1 = ((ModuleRevisionId)o1).getRevision();
            String rev2 = ((ModuleRevisionId)o2).getRevision();
            boolean latestRev1 = rev1.startsWith("latest") || rev1.startsWith("working");
            boolean bl = latestRev2 = rev2.startsWith("latest") || rev2.startsWith("working");
            if (latestRev1 && !latestRev2) {
                return 1;
            }
            if (latestRev2 && !latestRev1) {
                return -1;
            }
            rev1 = rev1.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            rev1 = rev1.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            rev2 = rev2.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            rev2 = rev2.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            String[] parts1 = rev1.split("[\\._\\-\\+]");
            String[] parts2 = rev2.split("[\\._\\-\\+]");
            int i = 0;
            while (i < parts1.length && i < parts2.length) {
                if (!parts1[i].equals(parts2[i])) {
                    boolean is1Number = this.isNumber(parts1[i]);
                    boolean is2Number = this.isNumber(parts2[i]);
                    if (is1Number && !is2Number) {
                        return 1;
                    }
                    if (is2Number && !is1Number) {
                        return -1;
                    }
                    if (is1Number && is2Number) {
                        return Long.valueOf(parts1[i]).compareTo(Long.valueOf(parts2[i]));
                    }
                    return parts1[i].compareTo(parts2[i]);
                }
                ++i;
            }
            if (i < parts1.length) {
                return this.isNumber(parts1[i]) ? 1 : -1;
            }
            if (i < parts2.length) {
                return this.isNumber(parts2[i]) ? -1 : 1;
            }
            return 0;
        }

        private boolean isNumber(String str) {
            return str.matches("\\d+");
        }
    }
}

