/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.actions;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.diagram.actions.DiagramNodeAddActionHandler;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.util.ListFactory;

public final class DiagramNodeAddActionHandlerFactory
extends SapphireActionHandlerFactory {
    private Listener nodeTemplateVisibilityListener;

    @Override
    public void init(SapphireAction action, ActionHandlerFactoryDef def) {
        super.init(action, def);
        this.nodeTemplateVisibilityListener = new FilteredListener<PartVisibilityEvent>(){

            protected void handleTypedEvent(PartVisibilityEvent event) {
                DiagramNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        };
        for (DiagramNodeTemplate nodeTemplate : ((SapphireDiagramEditorPagePart)this.getPart()).getNodeTemplates()) {
            nodeTemplate.attach(this.nodeTemplateVisibilityListener);
        }
    }

    @Override
    public List<SapphireActionHandler> create() {
        ListFactory handlers = ListFactory.start();
        for (DiagramNodeTemplate nodeTemplate : ((SapphireDiagramEditorPagePart)this.getPart()).getNodeTemplates()) {
            if (!nodeTemplate.visible()) continue;
            DiagramNodeAddActionHandler addNodeHandler = new DiagramNodeAddActionHandler(nodeTemplate);
            handlers.add((Object)addNodeHandler);
        }
        return handlers.result();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.nodeTemplateVisibilityListener != null) {
            for (DiagramNodeTemplate nodeTemplate : ((SapphireDiagramEditorPagePart)this.getPart()).getNodeTemplates()) {
                nodeTemplate.detach(this.nodeTemplateVisibilityListener);
            }
        }
    }
}

