/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Length;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.services.ContentProposalService;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.TextCapacityFeedback;
import org.eclipse.sapphire.ui.forms.swt.ValuePropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.TextFieldBinding;
import org.eclipse.sapphire.ui.forms.swt.internal.TextOverlayPainter;
import org.eclipse.sapphire.ui.listeners.ValuePropertyEditorListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class TextFieldPropertyEditorPresentation
extends ValuePropertyEditorPresentation {
    private Text textField;
    private static final String CONTENT_ASSIST_KEY_STROKE_STRING = "Ctrl+Space";
    private static final KeyStroke CONTENT_ASSIST_KEY_STROKE;

    static {
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)CONTENT_ASSIST_KEY_STROKE_STRING);
        }
        catch (ParseException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        CONTENT_ASSIST_KEY_STROKE = keyStroke;
    }

    public TextFieldPropertyEditorPresentation(FormComponentPart part, SwtPresentation parent, Composite composite) {
        super(part, parent, composite);
    }

    @Override
    protected void createContents(Composite parent) {
        this.createContents(parent, false);
    }

    protected Control createContents(Composite parent, final boolean suppressBrowseAction) {
        List listenerClasses;
        ContentProposalService contentProposalService;
        PropertyEditorPart part = this.part();
        Value property = (Value)part.property();
        ValueProperty pdef = property.definition();
        final boolean isLongString = pdef.hasAnnotation(LongString.class);
        boolean isDeprecated = pdef.hasAnnotation(Deprecated.class);
        final boolean isReadOnly = pdef.isReadOnly() || part.getRenderingHint("read.only", false);
        boolean isSensitiveData = pdef.hasAnnotation(SensitiveData.class);
        SapphireActionGroup actions = this.getActions();
        SapphireActionHandler jumpActionHandler = actions.getAction("Sapphire.Jump").getFirstActiveHandler();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(this.getActionPresentationManager());
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        actions.addFilter(new SapphireActionHandlerFilter(){

            @Override
            public boolean check(SapphireActionHandler handler) {
                String actionId = handler.getAction().getId();
                return !actionId.equals("Sapphire.Browse") || !isReadOnly && !suppressBrowseAction;
            }
        });
        boolean isActionsToolBarNeeded = toolBarActionsPresentation.hasActions();
        boolean isBrowseOnly = part.getRenderingHint("browse.only", false);
        Composite textFieldParent = this.createMainComposite(parent, new PropertyEditorPresentation.CreateMainCompositeDelegate(this, part){

            @Override
            public boolean canScaleVertically() {
                return isLongString;
            }
        });
        this.addControl((Control)textFieldParent);
        int textFieldParentColumns = 1;
        if (isActionsToolBarNeeded) {
            ++textFieldParentColumns;
        }
        if (isDeprecated) {
            ++textFieldParentColumns;
        }
        textFieldParent.setLayout((Layout)GridLayoutUtil.glayout(textFieldParentColumns, 0, 0, 0, 0));
        Composite nestedComposite = new Composite(textFieldParent, 0);
        nestedComposite.setLayoutData((Object)(isLongString ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000)));
        nestedComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        this.addControl((Control)nestedComposite);
        PropertyEditorAssistDecorator decorator = this.createDecorator(nestedComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        decorator.addEditorControl((Control)nestedComposite);
        int style = 0x800 | (isLongString ? 578 : 0) | (isReadOnly || isBrowseOnly ? 8 : 0) | (isSensitiveData ? 0x400000 : 0);
        this.textField = new Text(nestedComposite, style);
        this.textField.setLayoutData((Object)GridLayoutUtil.gdfill());
        decorator.addEditorControl((Control)this.textField, true);
        TextOverlayPainter.install(this.textField, property, (JumpActionHandler)jumpActionHandler, this);
        if (isBrowseOnly || isReadOnly) {
            final Color bgcolor = new Color((Device)this.textField.getDisplay(), 245, 245, 245);
            this.textField.setBackground(bgcolor);
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    bgcolor.dispose();
                }
            });
        }
        this.attachAccessibleName((Control)this.textField);
        ArrayList<ToolBar> relatedControls = new ArrayList<ToolBar>();
        this.textField.setData("related-controls", relatedControls);
        Listener actionHandlerListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireActionHandler.PostExecuteEvent && !TextFieldPropertyEditorPresentation.this.textField.isDisposed()) {
                    TextFieldPropertyEditorPresentation.this.textField.setFocus();
                    TextFieldPropertyEditorPresentation.this.textField.setSelection(0, TextFieldPropertyEditorPresentation.this.textField.getText().length());
                }
            }
        };
        for (SapphireAction action : actions.getActions()) {
            if (action.getId().equals("Sapphire.Assist")) continue;
            for (SapphireActionHandler handler : action.getActiveHandlers()) {
                handler.attach(actionHandlerListener);
            }
        }
        if (isActionsToolBarNeeded) {
            int alignment = isLongString ? 512 : 256;
            ToolBar toolbar = new ToolBar(textFieldParent, 0x800000 | alignment);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.addControl((Control)toolbar);
            decorator.addEditorControl((Control)toolbar);
            relatedControls.add(toolbar);
        }
        if ((contentProposalService = (ContentProposalService)property.service(ContentProposalService.class)) != null) {
            ContentProposalProvider contentProposalProvider = new ContentProposalProvider(contentProposalService, part);
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.textField, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)contentProposalProvider, CONTENT_ASSIST_KEY_STROKE, null);
            contentProposalAdapter.setPropagateKeys(true);
            contentProposalAdapter.setLabelProvider((ILabelProvider)new ContentProposalLabelProvider());
            contentProposalAdapter.setProposalAcceptanceStyle(2);
        }
        if (isDeprecated) {
            Control deprecationMarker = this.createDeprecationMarker(textFieldParent);
            deprecationMarker.setLayoutData((Object)GridLayoutUtil.gd());
        }
        this.binding = new TextFieldBinding((PropertyEditorPresentation)this, this.textField);
        this.textField.setData("binding", (Object)this.binding);
        this.addControl((Control)this.textField);
        Length lengthAnnotation = (Length)pdef.getAnnotation(Length.class);
        if (lengthAnnotation != null && lengthAnnotation.max() < Integer.MAX_VALUE) {
            boolean span = this.part().getSpanBothColumns();
            if (!span) {
                new Label(parent, 0);
            }
            TextCapacityFeedback textCapacityFeedback = new TextCapacityFeedback(parent, this.textField, lengthAnnotation.max());
            textCapacityFeedback.setLayoutData(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhfill(), 9), span ? 2 : 1));
            this.addControl((Control)textCapacityFeedback);
            decorator.addEditorControl((Control)textCapacityFeedback);
        }
        if (!(listenerClasses = part.getRenderingHint("listeners", Collections.emptyList())).isEmpty()) {
            final ArrayList<ValuePropertyEditorListener> listeners = new ArrayList<ValuePropertyEditorListener>();
            for (Class cl : listenerClasses) {
                try {
                    ValuePropertyEditorListener listener = (ValuePropertyEditorListener)cl.newInstance();
                    listener.initialize(this);
                    listeners.add(listener);
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
            }
            if (!listeners.isEmpty()) {
                this.textField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        for (ValuePropertyEditorListener listener : listeners) {
                            try {
                                listener.handleValueChanged();
                            }
                            catch (Exception e) {
                                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        return this.textField;
    }

    @Override
    protected boolean canScaleVertically() {
        return this.property().definition().hasAnnotation(LongString.class);
    }

    @Override
    protected void handleFocusReceivedEvent() {
        this.textField.setFocus();
    }

    private static final class ContentProposalLabelProvider
    extends LabelProvider {
        private ContentProposalLabelProvider() {
        }

        public Image getImage(Object element) {
            return ((ImageContentProposal)((Object)element)).getImage();
        }

        public String getText(Object element) {
            return ((ImageContentProposal)((Object)element)).getLabel();
        }
    }

    private static final class ContentProposalProvider
    implements IContentProposalProvider {
        private ContentProposalService contentProposalService;
        private ContentProposalService.Session session = null;
        private SapphirePart sapphirePart;

        public ContentProposalProvider(ContentProposalService contentProposalService, SapphirePart sapphirePart) {
            this.contentProposalService = contentProposalService;
            this.sapphirePart = sapphirePart;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            if (this.session == null) {
                this.session = this.contentProposalService.session();
            }
            String oldFilter = this.session.filter();
            int oldFilterLength = oldFilter.length();
            String newFilter = contents.substring(0, position);
            if (position < oldFilterLength || !oldFilter.equals(newFilter)) {
                this.session = this.contentProposalService.session();
                if (position > 0) {
                    this.session.advance(newFilter);
                }
            } else if (position > oldFilterLength) {
                this.session.advance(newFilter.substring(oldFilterLength));
            }
            List filterProposals = this.session.proposals();
            IContentProposal[] arrContentProposals = this.makeProposalArray(filterProposals);
            return arrContentProposals;
        }

        private IContentProposal[] makeProposalArray(List<org.eclipse.sapphire.services.ContentProposal> proposals) {
            if (proposals != null) {
                IContentProposal[] arrContentProposals = new IContentProposal[proposals.size()];
                int i = 0;
                while (i < proposals.size()) {
                    org.eclipse.sapphire.services.ContentProposal contentProposalInfo = proposals.get(i);
                    ImageContentProposal contentProposal = new ImageContentProposal(contentProposalInfo.content(), contentProposalInfo.label(), contentProposalInfo.description(), contentProposalInfo.content().length(), this.sapphirePart.getSwtResourceCache().image(contentProposalInfo.image()));
                    arrContentProposals[i] = contentProposal;
                    ++i;
                }
                return arrContentProposals;
            }
            return new IContentProposal[0];
        }
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        @Override
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            if (part.property().definition() instanceof ValueProperty) {
                return new TextFieldPropertyEditorPresentation(part, parent, composite);
            }
            return null;
        }
    }

    private static final class ImageContentProposal
    extends ContentProposal {
        private Image image;

        public ImageContentProposal(String content, String label, String description, int cursorPosition, Image image) {
            super(content, label, description, cursorPosition);
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

