/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.queryspecifications.querybuilder;

import org.eclipse.wst.xml.search.core.queryspecifications.querybuilder.IStringQueryBuilder;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.w3c.dom.Node;

public abstract class AbstractStringQueryBuilder
implements IStringQueryBuilder {
    private static final String NORMALIZE_SPACE_TEXT = "normalize-space(text())";
    private static final String TEXT_TARGETNODE = "text()";

    public String getNodeValue(Node node) {
        return DOMUtils.getNodeValue(node);
    }

    @Override
    public String build(String baseQuery, String[] targetNodes, Object selectedNode) {
        return this.build(baseQuery, targetNodes, 0, selectedNode);
    }

    @Override
    public String build(String baseQuery, String[] targetNodes, int startIndex, Object selectedNode) {
        if (targetNodes == null) {
            targetNodes = StringUtils.EMPTY_ARRAY;
        }
        baseQuery = baseQuery.replaceAll("'", "''");
        StringBuilder xpath = new StringBuilder(baseQuery);
        if (baseQuery.endsWith("//")) {
            xpath.append("*");
        }
        this.build(xpath, targetNodes, startIndex, selectedNode);
        if (targetNodes.length > 0 && this.addLastTargetNodeAtEnds()) {
            xpath.append("/");
            xpath.append(targetNodes[targetNodes.length - 1]);
        }
        return xpath.toString();
    }

    protected String getTargetNode(String targetNode) {
        if (TEXT_TARGETNODE.equals(targetNode)) {
            targetNode = NORMALIZE_SPACE_TEXT;
        }
        return targetNode;
    }

    protected boolean addLastTargetNodeAtEnds() {
        return true;
    }

    protected abstract void build(StringBuilder var1, String[] var2, int var3, Object var4);
}

