/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.reporter;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;

public class SysOutSearchReporter
implements IXMLSearchReporter {
    public static final IXMLSearchReporter INSTANCE = new SysOutSearchReporter();

    @Override
    public void beginSearch(int searchId, Map<IResource, Collection<String>> queries) {
        System.out.println("Start search [" + searchId + "]");
        Set<Map.Entry<IResource, Collection<String>>> entries = queries.entrySet();
        for (Map.Entry<IResource, Collection<String>> entry : entries) {
            System.out.print("\tresources=");
            System.out.println(entry.getKey().getFullPath());
            System.out.print("\t\tqueries=");
            Collection<String> q = entry.getValue();
            boolean first = true;
            for (String query : q) {
                if (!first) {
                    System.out.print(", ");
                }
                System.out.print(query);
                first = false;
            }
            System.out.println();
        }
    }

    @Override
    public void endSearch(int searchId, long elapsedTime) {
        System.out.println("End search [" + searchId + "] with " + elapsedTime + "(ms).");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

