/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.core.xpath;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.search.core.xpath.AbstractXPathProcessor;
import org.eclipse.wst.xml.search.core.xpath.NamespaceInfos;
import org.w3c.dom.NodeList;

public abstract class AbstractXPathProcessorForXPathFactory
extends AbstractXPathProcessor {
    private Map<String, XPathExpression> expressions = new HashMap<String, XPathExpression>();
    private XPathFactory factory;

    @Override
    public NodeList evaluateNodeSet(Object source, String xpath, NamespaceInfos namespaceInfo, String ... criteria) throws XPathExpressionException {
        return (NodeList)this.evaluate(source, XPathConstants.NODESET, xpath, namespaceInfo, criteria);
    }

    @Override
    public String evaluateString(Object source, String xpath, NamespaceInfos namespaceInfo, String ... criteria) throws XPathExpressionException {
        return (String)this.evaluate(source, XPathConstants.STRING, xpath, namespaceInfo, criteria);
    }

    public Object evaluate(Object source, QName name, String xpath, NamespaceInfos namespaceInfo, String ... criteria) throws XPathExpressionException {
        XPathExpression expr = this.getXPathExpression(xpath, namespaceInfo, criteria);
        return expr.evaluate(source, name);
    }

    protected XPathExpression getXPathExpression(String xpath, NamespaceInfos namespaceInfo, String ... args) throws XPathExpressionException {
        XPathExpression exp = this.expressions.get(xpath = this.computeXPath(xpath, args));
        if (exp == null) {
            exp = this.createXPathExpression(xpath, namespaceInfo);
        }
        return exp;
    }

    protected XPathExpression createXPathExpression(String expression, NamespaceInfos namespaceInfo) throws XPathExpressionException {
        XPath xpath = this.getFactory().newXPath();
        if (namespaceInfo != null && namespaceInfo.size() > 0) {
            xpath.setNamespaceContext(namespaceInfo);
        }
        XPathExpression expr = xpath.compile(expression);
        return expr;
    }

    @Override
    public IStatus validateXPath(String xpath) {
        try {
            this.createXPathExpression(xpath, null);
        }
        catch (XPathExpressionException e) {
            return this.createStatusForXPathNotValid(xpath, "org.eclipse.wst.xml.search.core", e);
        }
        return Status.OK_STATUS;
    }

    public XPathFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        return this.factory;
    }

    protected abstract XPathFactory createFactory();
}

