/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.editor;

import com.liferay.ide.server.core.portal.PortalServer;
import com.liferay.ide.server.ui.cmd.SetPortalServerPasswordCommand;
import com.liferay.ide.server.ui.cmd.SetPortalServerUsernameCommand;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class PortalServerAccountEditorSection
extends ServerEditorSection {
    protected Section section;
    protected PortalServer portalServer;
    protected Hyperlink setDefault;
    protected boolean defaultDeployDirIsSet;
    protected Text password;
    protected Text username;
    protected boolean updating;
    protected PropertyChangeListener listener;
    protected IPublishListener publishListener;
    protected boolean allowRestrictedEditing;

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (PortalServerAccountEditorSection.this.updating) {
                    return;
                }
                PortalServerAccountEditorSection.this.updating = true;
                if ("username".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    PortalServerAccountEditorSection.this.username.setText(s);
                    PortalServerAccountEditorSection.this.validate();
                } else if ("password".equals(event.getPropertyName())) {
                    String s = (String)event.getNewValue();
                    PortalServerAccountEditorSection.this.password.setText(s);
                    PortalServerAccountEditorSection.this.validate();
                }
                PortalServerAccountEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.publishListener = new PublishAdapter(){

            public void publishFinished(IServer server2, IStatus status) {
                boolean flag = false;
                if (status.isOK() && server2.getModules().length == 0) {
                    flag = true;
                }
                if (flag != PortalServerAccountEditorSection.this.allowRestrictedEditing) {
                    PortalServerAccountEditorSection.this.allowRestrictedEditing = flag;
                }
            }
        };
        this.server.getOriginal().addPublishListener(this.publishListener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Msgs.liferayAccount);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.seop0002");
        whs.setHelp((Control)this.section, "org.eclipse.wst.server.ui.seop0002");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        GridData data = new GridData(1, 0x1000000, false, false);
        Label label = this.createLabel(toolkit, composite, Msgs.username);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.username = toolkit.createText(composite, null);
        this.username.setLayoutData((Object)new GridData(4, 128, true, false));
        this.username.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PortalServerAccountEditorSection.this.updating) {
                    return;
                }
                PortalServerAccountEditorSection.this.updating = true;
                PortalServerAccountEditorSection.this.execute((IUndoableOperation)new SetPortalServerUsernameCommand(PortalServerAccountEditorSection.this.server, PortalServerAccountEditorSection.this.username.getText().trim()));
                PortalServerAccountEditorSection.this.updating = false;
            }
        });
        label = this.createLabel(toolkit, composite, "");
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        label = this.createLabel(toolkit, composite, Msgs.password);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.password = toolkit.createText(composite, null, 0x400000);
        this.password.setLayoutData((Object)new GridData(4, 128, true, false));
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PortalServerAccountEditorSection.this.updating) {
                    return;
                }
                PortalServerAccountEditorSection.this.updating = true;
                PortalServerAccountEditorSection.this.execute((IUndoableOperation)new SetPortalServerPasswordCommand(PortalServerAccountEditorSection.this.server, PortalServerAccountEditorSection.this.password.getText().trim()));
                PortalServerAccountEditorSection.this.updating = false;
            }
        });
        this.setDefault = toolkit.createHyperlink(composite, Msgs.restoreDefaultsLink, 64);
        this.setDefault.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PortalServerAccountEditorSection.this.updating = true;
                PortalServerAccountEditorSection.this.execute((IUndoableOperation)new SetPortalServerUsernameCommand(PortalServerAccountEditorSection.this.server, "test@liferay.com"));
                PortalServerAccountEditorSection.this.username.setText("test@liferay.com");
                PortalServerAccountEditorSection.this.execute((IUndoableOperation)new SetPortalServerPasswordCommand(PortalServerAccountEditorSection.this.server, ""));
                PortalServerAccountEditorSection.this.password.setText("");
                PortalServerAccountEditorSection.this.updating = false;
                PortalServerAccountEditorSection.this.validate();
            }
        });
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        this.setDefault.setLayoutData((Object)data);
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
            if (this.server.getOriginal() != null) {
                this.server.getOriginal().removePublishListener(this.publishListener);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.portalServer = (PortalServer)this.server.loadAdapter(PortalServer.class, null);
            this.addChangeListeners();
        }
    }

    protected void initialize() {
        if (this.portalServer == null) {
            return;
        }
        this.updating = true;
        this.username.setText(this.portalServer.getUsername());
        this.password.setText(this.portalServer.getPassword());
        this.updating = false;
        this.validate();
    }

    protected void validate() {
        if (this.portalServer != null) {
            this.setErrorMessage(null);
        }
    }

    private static class Msgs
    extends NLS {
        public static String liferayAccount;
        public static String password;
        public static String username;
        public static String restoreDefaultsLink;

        static {
            Msgs.initializeMessages((String)PortalServerAccountEditorSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

