/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.handlers;

import com.liferay.ide.server.core.ILiferayServerBehavior;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.server.ui.util.ServerUIUtil;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;

public class OpenDeployedFolderHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPath folder;
        IStructuredSelection structuredSelection;
        Object selected;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selected = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && (folder = this.getDeployFolderPath(selected)) != null) {
            try {
                String launchCmd = ServerUIUtil.getSystemExplorerCommand(folder.toFile());
                ServerUIUtil.openInSystemExplorer(launchCmd, folder.toFile());
            }
            catch (IOException e) {
                LiferayServerUI.logError("Unable to execute command", e);
            }
        }
        return null;
    }

    private IPath getDeployFolderPath(Object selected) {
        IPath retval = null;
        ModuleServer moduleServer = null;
        if (selected != null && selected instanceof ModuleServer) {
            moduleServer = (ModuleServer)selected;
            moduleServer.getModule()[0].getProject();
            ILiferayServerBehavior liferayServerBehavior = (ILiferayServerBehavior)moduleServer.getServer().loadAdapter(ILiferayServerBehavior.class, null);
            if (liferayServerBehavior != null) {
                retval = liferayServerBehavior.getDeployedPath(moduleServer.getModule());
            }
        }
        return retval;
    }
}

