/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.portal;

import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.core.portal.PortalRuntime;
import com.liferay.ide.server.ui.LiferayServerUI;
import com.liferay.ide.ui.util.SWTUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class PortalRuntimeComposite
extends Composite
implements ModifyListener {
    private Text dirField;
    private List<IVMInstall> installedJREs;
    private String[] jreNames;
    private Button jreButton;
    private Combo jreCombo;
    private Label jreLabel;
    private Text nameField;
    private IRuntimeWorkingCopy runtimeWC;
    private Text typeField;
    private final IWizardHandle wizard;

    public PortalRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Msgs.liferayPortalRuntime);
        wizard.setDescription(Msgs.specifyInstallationDirectory);
        wizard.setImageDescriptor(LiferayServerUI.getImageDescriptor("imgWizRuntime"));
        this.createControl(parent);
    }

    protected void createControl(Composite parent) {
        this.setLayout(this.createLayout());
        this.setLayoutData(this.createLayoutData());
        this.setBackground(parent.getBackground());
        this.createFields();
        this.enableJREControls(false);
        Dialog.applyDialogFont((Control)this);
    }

    private void createFields() {
        this.nameField = this.createTextField(Msgs.name);
        this.nameField.addModifyListener((ModifyListener)this);
        this.dirField = this.createTextField(Msgs.liferayPortalRuntimeDirectory);
        this.dirField.addModifyListener((ModifyListener)this);
        SWTUtil.createButton((Composite)this, (String)Msgs.browse).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(PortalRuntimeComposite.this.getShell());
                dd.setMessage(Msgs.selectLiferayPortalDirectory);
                String selectedDir = dd.open();
                if (selectedDir != null) {
                    PortalRuntimeComposite.this.dirField.setText(selectedDir);
                }
            }
        });
        this.typeField = this.createReadOnlyTextField(Msgs.detectedPortalBundleType);
        this.jreLabel = this.createLabel(Msgs.selecteRuntimeJRE);
        this.jreCombo = new Combo((Composite)this, 12);
        this.jreCombo.setLayoutData((Object)new GridData(768));
        this.jreCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PortalRuntime portalRuntime;
                int sel = PortalRuntimeComposite.this.jreCombo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = (IVMInstall)PortalRuntimeComposite.this.installedJREs.get(sel - 1);
                }
                if ((portalRuntime = PortalRuntimeComposite.this.getPortalRuntime()) != null) {
                    portalRuntime.setVMInstall(vmInstall);
                }
                PortalRuntimeComposite.this.validate();
            }
        });
        this.jreButton = SWTUtil.createButton((Composite)this, (String)Msgs.installedJREs);
        this.jreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTUtil.showPreferencePage((String)"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage", (Shell)PortalRuntimeComposite.this.getShell())) {
                    PortalRuntimeComposite.this.updateJREs();
                    PortalRuntimeComposite.this.validate();
                }
            }
        });
    }

    protected Label createLabel(String text) {
        Label label = new Label((Composite)this, 0);
        label.setText(text);
        GridDataFactory.generate((Control)label, (int)2, (int)1);
        return label;
    }

    protected Layout createLayout() {
        return new GridLayout(2, false);
    }

    private GridData createLayoutData() {
        return new GridData(1808);
    }

    protected Text createReadOnlyTextField(String labelText) {
        return this.createTextField(labelText, 8);
    }

    protected Text createTextField(String labelText) {
        return this.createTextField(labelText, 0);
    }

    protected Text createTextField(String labelText, int style) {
        this.createLabel(labelText);
        Text text = new Text((Composite)this, 0x800 | style);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected void enableJREControls(boolean enabled) {
        this.jreLabel.setEnabled(enabled);
        this.jreCombo.setEnabled(enabled);
        this.jreButton.setEnabled(enabled);
    }

    protected PortalRuntime getPortalRuntime() {
        return (PortalRuntime)this.getRuntime().loadAdapter(PortalRuntime.class, null);
    }

    protected IRuntimeWorkingCopy getRuntime() {
        return this.runtimeWC;
    }

    protected void init() {
        if (this.dirField == null || this.nameField == null || this.getRuntime() == null) {
            return;
        }
        PortalRuntimeComposite.setFieldValue(this.nameField, this.getRuntime().getName());
        PortalRuntimeComposite.setFieldValue(this.dirField, this.getRuntime().getLocation() != null ? this.getRuntime().getLocation().toOSString() : "");
        this.updateFields();
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource().equals(this.dirField)) {
            this.getRuntime().setLocation((IPath)new Path(this.dirField.getText()));
        } else if (e.getSource().equals(this.nameField)) {
            this.getRuntime().setName(this.nameField.getText());
        }
        this.updateFields();
        this.validate();
        this.enableJREControls(true);
        this.updateJREs();
    }

    public void setRuntime(IRuntimeWorkingCopy newRuntime) {
        this.runtimeWC = newRuntime == null ? null : newRuntime;
        this.init();
        this.validate();
    }

    private void updateFields() {
        PortalRuntime portalRuntime = this.getPortalRuntime();
        if (portalRuntime != null) {
            PortalBundle portalBundle = portalRuntime.getPortalBundle();
            PortalRuntimeComposite.setFieldValue(this.typeField, portalBundle != null ? portalBundle.getType() : "");
        }
    }

    protected void validate() {
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }

    public static void setFieldValue(Text field, String value) {
        if (field != null && !field.isDisposed()) {
            field.setText(value != null ? value : "");
        }
    }

    protected void updateJREs() {
        PortalRuntime portalRuntime = this.getPortalRuntime();
        IVMInstall currentVM = null;
        currentVM = portalRuntime != null && portalRuntime.getVMInstall() != null ? portalRuntime.getVMInstall() : JavaRuntime.getDefaultVMInstall();
        int currentJREIndex = -1;
        this.installedJREs = new ArrayList<IVMInstall>();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = Msgs.defaultWorkbenchJRE;
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            if (vmInstall.equals(currentVM)) {
                currentJREIndex = i + 1;
            }
            ++i;
        }
        if (this.jreCombo != null) {
            this.jreCombo.setItems(this.jreNames);
            this.jreCombo.select(currentJREIndex);
        }
    }

    static class Msgs
    extends NLS {
        public static String browse;
        public static String defaultWorkbenchJRE;
        public static String detectedPortalBundleType;
        public static String installedJREs;
        public static String liferayPortalRuntime;
        public static String liferayPortalRuntimeDirectory;
        public static String name;
        public static String selecteRuntimeJRE;
        public static String selectLiferayPortalDirectory;
        public static String specifyInstallationDirectory;

        static {
            Msgs.initializeMessages((String)PortalRuntimeComposite.class.getName(), Msgs.class);
        }

        Msgs() {
        }
    }
}

