/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.Constants;
import org.eclipse.epp.internal.logging.aeri.ui.ExpiringReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.INotificationService;
import org.eclipse.epp.internal.logging.aeri.ui.ReportingController;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.LogListener;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseUpdateJob;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.model.PreferenceInitializer;
import org.eclipse.epp.internal.logging.aeri.ui.model.RememberSendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.MylynNotificationService;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Shells;
import org.eclipse.epp.internal.logging.aeri.ui.v2.AeriServer;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Startup
implements IStartup {
    private ReportHistory history;
    private Settings settings;
    private AeriServer server;
    private ServerConfiguration configuration;
    private ReportingController controller;
    private EventBus bus;
    private ExpiringReportHistory expiringReportHistory;
    private ProblemsDatabaseService problemsDb;

    public void earlyStartup() {
        if (Boolean.getBoolean("org.eclipse.epp.logging.aeri.ui.skipReports")) {
            return;
        }
        Shells.isUIThread();
        new Job("Initializing Error Reporting System"){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Initializing error reporting", (int)10);
                try {
                    progress.subTask("history");
                    Startup.this.initializeHistory();
                    progress.worked(1);
                    progress.subTask("expiring history");
                    Startup.this.initializeExpiringHistory();
                    progress.worked(1);
                    progress.subTask("problem database");
                    Startup.this.initializeProblemsDatabase();
                    progress.worked(1);
                    progress.subTask("settings");
                    Startup.this.initalizeSettings();
                    progress.worked(1);
                    progress.subTask("server");
                    Startup.this.initializeServerAndConfiguration(monitor);
                    progress.worked(1);
                    progress.subTask("eventbus");
                    Startup.this.initalizeEventBus();
                    progress.worked(1);
                    progress.subTask("controller");
                    Startup.this.initalizeController();
                    progress.worked(1);
                    progress.subTask("log listener");
                    Startup.this.initalizeLogListener();
                    progress.worked(1);
                    progress.subTask("jobs");
                    Startup.this.scheduleJobs();
                    progress.worked(1);
                    monitor.done();
                }
                catch (SocketException | UnknownHostException e) {
                    if (Constants.DEBUG) {
                        Logs.log((Logs.ILogMessage)LogMessages.WARN_STARTUP_FAILED, (Throwable)e);
                    }
                    Startup.this.settings.setAction(SendAction.IGNORE);
                    Startup.this.settings.setRememberSendAction(RememberSendAction.RESTART);
                }
                catch (Exception e) {
                    Logs.log((Logs.ILogMessage)LogMessages.WARN_STARTUP_FAILED, (Throwable)e);
                    Startup.this.settings.setAction(SendAction.IGNORE);
                    Startup.this.settings.setRememberSendAction(RememberSendAction.RESTART);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void initializeHistory() {
        try {
            this.history = new ReportHistory();
            this.history.startAsync();
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    try {
                        Startup.this.history.stopAsync();
                        Startup.this.history.awaitTerminated();
                    }
                    catch (Exception exception) {
                        Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_STOP_FAILED);
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_START_FAILED, (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    private void initializeProblemsDatabase() {
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
            File indexDirectory = new File(stateLocation.toFile(), "remote-index");
            this.problemsDb = new ProblemsDatabaseService(indexDirectory);
            this.problemsDb.startAsync();
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    try {
                        Startup.this.problemsDb.stopAsync();
                        Startup.this.problemsDb.awaitTerminated();
                    }
                    catch (Exception exception) {
                        Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_STOP_FAILED);
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_START_FAILED, (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    private void initializeExpiringHistory() {
        this.expiringReportHistory = new ExpiringReportHistory();
    }

    private void initalizeSettings() {
        this.settings = PreferenceInitializer.getDefault();
    }

    private void initializeServerAndConfiguration(IProgressMonitor monitor) throws UnknownHostException, SocketException {
        try {
            Executor executor = Executor.newInstance();
            File configurationFile = new File(this.settings.getServerConfigurationLocalFile());
            this.server = new AeriServer(executor, configurationFile);
            if (configurationFile.exists()) {
                this.server.loadConfiguration();
                this.configuration = this.server.getConfiguration();
            }
            if (this.configuration == null || this.server.isConfigurationOutdated()) {
                this.server.refreshConfiguration(this.settings.getServerUrl(), monitor);
                this.server.saveConfiguration();
                this.configuration = this.server.getConfiguration();
            }
        }
        catch (SocketException | UnknownHostException e) {
            throw e;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_CONFIGURATION_DOWNLOAD_FAILED, (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
    }

    private void initalizeEventBus() {
        this.bus = new EventBus("Error Reporting Bus");
    }

    private void initalizeController() {
        this.controller = new ReportingController(this.bus, this.settings, this.configuration, this.server, (INotificationService)new MylynNotificationService(this.bus), this.history, this.problemsDb);
        this.bus.register((Object)this.controller);
    }

    private void initalizeLogListener() {
        LogListener listener = LogListener.createLogListener((Settings)this.settings, (ServerConfiguration)this.configuration, (ReportHistory)this.history, (EventBus)this.bus, (ExpiringReportHistory)this.expiringReportHistory, (ProblemsDatabaseService)this.problemsDb);
        Platform.addLogListener((ILogListener)listener);
    }

    private void scheduleJobs() {
        try {
            Job job = new Job("schedule problem database update"){

                protected IStatus run(IProgressMonitor monitor) {
                    new ProblemsDatabaseUpdateJob(Startup.this.problemsDb, Startup.this.server, Startup.this.settings).schedule();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            long outdatedTimestamp = this.configuration.getProblemsZipLastDownloadTimestamp() + this.configuration.getProblemsTtlMs();
            long timeToUpdate = outdatedTimestamp - System.currentTimeMillis();
            long scheduleMs = Math.max(TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS), timeToUpdate);
            job.schedule(scheduleMs);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

