/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.PortalLaunchParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerUtil;

public class PortalSourceLookupDirector
extends JavaSourceLookupDirector {
    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        super.initializeDefaults(configuration);
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento != null) {
            this.initializeFromMemento(memento, configuration);
        }
        this.setSourcePathComputer(configuration.getType().getSourcePathComputer());
    }

    public void configureLaunch(final ILaunch launch) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)launch.getLaunchConfiguration());
        server.addServerListener(new IServerListener(server){
            IModule[] modules;
            {
                this.modules = iServer.getModules();
            }

            private boolean modulesChanged(IModule[] modules, IModule[] modules2) {
                if (CoreUtil.isNullOrEmpty((Object[])modules) && CoreUtil.isNullOrEmpty((Object[])modules2)) {
                    return true;
                }
                if (CoreUtil.isNullOrEmpty((Object[])modules) || CoreUtil.isNullOrEmpty((Object[])modules2)) {
                    return true;
                }
                if (modules.length != modules2.length) {
                    return true;
                }
                int i = 0;
                while (i < modules.length) {
                    if (!modules[i].equals(modules2[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public synchronized void serverChanged(ServerEvent event) {
                IModule[] newModules;
                if ((event.getKind() & 0x20) > 0 && this.modulesChanged(this.modules, newModules = event.getServer().getModules())) {
                    try {
                        PortalSourceLookupDirector director = (PortalSourceLookupDirector)launch.getSourceLocator();
                        director.initializeDefaults(launch.getLaunchConfiguration());
                    }
                    catch (Exception e) {
                        LiferayServerCore.logError("Unable to update source containers for server", e);
                    }
                    this.modules = newModules;
                }
            }
        });
        launch.setSourceLocator((ISourceLocator)this);
    }

    public void initializeParticipants() {
        super.initializeParticipants();
        PortalLaunchParticipant[] portalLaunchParticipantArray = LiferayServerCore.getPortalLaunchParticipants();
        int n = portalLaunchParticipantArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortalLaunchParticipant participant = portalLaunchParticipantArray[n2];
            this.addParticipants(participant.getPortalSourceLookupParticipants());
            ++n2;
        }
    }

    public boolean isFindDuplicates() {
        return true;
    }
}

