/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import aQute.remote.api.Agent;
import aQute.remote.api.Event;
import aQute.remote.api.Supervisor;
import aQute.remote.util.AgentSupervisor;
import com.liferay.ide.server.core.portal.BundleDTOWithStatus;
import java.io.File;
import java.io.FileInputStream;
import java.util.jar.JarInputStream;
import org.osgi.framework.dto.BundleDTO;

public class BundleSupervisor
extends AgentSupervisor<Supervisor, Agent>
implements Supervisor {
    private String lastOutput;

    public boolean stderr(String out) throws Exception {
        return true;
    }

    public void connect(String host, int port) throws Exception {
        super.connect(Agent.class, (Object)this, host, port);
    }

    public void event(Event e) throws Exception {
    }

    public BundleDTO deploy(String bsn, File bundleFile, String bundleUrl, BundleDTO[] existingBundles) throws Exception {
        BundleDTO retval = null;
        boolean isFragment = false;
        if (!bundleUrl.contains("webbundle:")) {
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (JarInputStream jarStream = new JarInputStream(new FileInputStream(bundleFile));){
                    isFragment = jarStream.getManifest().getMainAttributes().getValue("Fragment-Host") != null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        }
        Agent agent = (Agent)this.getAgent();
        String sha = this.addFile(bundleFile);
        long bundleId = -1L;
        BundleDTO[] bundleDTOArray = existingBundles;
        int n = existingBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDTO bundle = bundleDTOArray[n2];
            if (bundle.symbolicName.equals(bsn)) {
                bundleId = bundle.id;
                retval = bundle;
                break;
            }
            ++n2;
        }
        if (bundleId > 0L) {
            if (!isFragment) {
                agent.stop(new long[]{bundleId});
            }
            if (bundleUrl.contains("webbundle:")) {
                agent.updateFromURL(bundleId, bundleUrl);
            } else {
                agent.update(bundleId, sha);
            }
            if (!isFragment) {
                agent.start(new long[]{bundleId});
            }
        } else {
            String startStatus;
            retval = bundleUrl.contains("webbundle:") ? agent.installFromURL(bundleUrl, bundleUrl) : agent.install(bundleUrl, sha);
            if (!isFragment && (startStatus = agent.start(new long[]{retval.id})) != null) {
                retval = new BundleDTOWithStatus(retval, startStatus);
            }
        }
        return retval;
    }

    public String getOutInfo() {
        return this.lastOutput;
    }

    public boolean stdout(String out) throws Exception {
        if (!("".equals(out) || out == null || "".equals(out = out.replaceAll("^>.*$", "")) || out.startsWith("true"))) {
            this.lastOutput = out;
        }
        return true;
    }
}

