/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.osgi.framework.dto.BundleDTO;

public class JMXBundleDeployer {
    private static final String OBJECTNAME = "osgi.core";
    protected MBeanServerConnection mBeanServerConnection;

    public JMXBundleDeployer() {
        this(JMXBundleDeployer.getLocalConnectorAddress());
    }

    public JMXBundleDeployer(int port) {
        this("service:jmx:rmi:///jndi/rmi://:" + port + "/jmxrmi");
    }

    public JMXBundleDeployer(String serviceURL) {
        try {
            JMXServiceURL jmxServiceUrl = new JMXServiceURL(serviceURL);
            JMXConnector jmxConnector = this.connectWithTimeout(jmxServiceUrl, 5L, TimeUnit.SECONDS);
            this.mBeanServerConnection = jmxConnector.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to get JMX connection", e);
        }
    }

    JMXConnector connectWithTimeout(final JMXServiceURL url, long timeout, TimeUnit unit) throws Exception {
        final ArrayBlockingQueue<String> queue = new ArrayBlockingQueue<String>(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JMXConnector connector = JMXConnectorFactory.connect(url);
                    if (!queue.offer(connector)) {
                        connector.close();
                    }
                }
                catch (IOException iOException) {}
            }
        });
        Object result = queue.poll(timeout, unit);
        if (result == null && !queue.offer("")) {
            result = queue.take();
        }
        return (JMXConnector)result;
    }

    public long deploy(String bsn, String bundleUrl) throws Exception {
        ObjectName framework = JMXBundleDeployer.getFramework(this.mBeanServerConnection);
        long bundleId = -1L;
        BundleDTO[] bundleDTOArray = this.listBundles();
        int n = bundleDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDTO osgiBundle = bundleDTOArray[n2];
            if (osgiBundle.symbolicName.equals(bsn)) {
                bundleId = osgiBundle.id;
                break;
            }
            ++n2;
        }
        if (bundleId > -1L) {
            this.mBeanServerConnection.invoke(framework, "stopBundle", new Object[]{bundleId}, new String[]{"long"});
            this.mBeanServerConnection.invoke(framework, "updateBundleFromURL", new Object[]{bundleId, bundleUrl}, new String[]{"long", String.class.getName()});
            this.mBeanServerConnection.invoke(framework, "refreshBundle", new Object[]{bundleId}, new String[]{"long"});
        } else {
            Object installed = this.mBeanServerConnection.invoke(framework, "installBundleFromURL", new Object[]{bundleUrl, bundleUrl}, new String[]{String.class.getName(), String.class.getName()});
            bundleId = Long.parseLong(installed.toString());
        }
        this.mBeanServerConnection.invoke(framework, "startBundle", new Object[]{bundleId}, new String[]{"long"});
        return bundleId;
    }

    private ObjectName getBundleState() throws MalformedObjectNameException, IOException {
        return this.mBeanServerConnection.queryNames(new ObjectName("osgi.core:type=bundleState,*"), null).iterator().next();
    }

    private static ObjectName getFramework(MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, IOException {
        ObjectName objectName = new ObjectName("osgi.core:type=framework,*");
        Set<ObjectName> objectNames = mBeanServerConnection.queryNames(objectName, null);
        if (objectNames != null && objectNames.size() > 0) {
            return objectNames.iterator().next();
        }
        return null;
    }

    public BundleDTO[] listBundles() {
        ArrayList<BundleDTO> retval = new ArrayList<BundleDTO>();
        try {
            ObjectName bundleState = this.getBundleState();
            Object[] params = new Object[]{new String[]{"Identifier", "SymbolicName", "State", "Version"}};
            String[] signature = new String[]{String[].class.getName()};
            TabularData data = (TabularData)this.mBeanServerConnection.invoke(bundleState, "listBundles", params, signature);
            for (Object value : data.values()) {
                CompositeData cd = (CompositeData)value;
                try {
                    retval.add(JMXBundleDeployer.newFromData(cd));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval.toArray(new BundleDTO[0]);
    }

    private static BundleDTO newFromData(CompositeData cd) {
        BundleDTO dto = new BundleDTO();
        dto.id = Long.parseLong(cd.get("Identifier").toString());
        dto.symbolicName = cd.get("SymbolicName").toString();
        String state = cd.get("State").toString();
        if ("UNINSTALLED".equals(state)) {
            dto.state = 1;
        } else if ("INSTALLED".equals(state)) {
            dto.state = 2;
        } else if ("RESOLVED".equals(state)) {
            dto.state = 4;
        } else if ("STARTING".equals(state)) {
            dto.state = 8;
        } else if ("STOPPING".equals(state)) {
            dto.state = 16;
        } else if ("ACTIVE".equals(state)) {
            dto.state = 32;
        }
        dto.version = cd.get("Version").toString();
        return dto;
    }

    public void uninstall(String bsn) throws Exception {
        BundleDTO[] bundleDTOArray = this.listBundles();
        int n = bundleDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDTO osgiBundle = bundleDTOArray[n2];
            if (osgiBundle.symbolicName.equals(bsn)) {
                this.uninstall(osgiBundle.id);
                return;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to uninstall " + bsn);
    }

    public void uninstall(long id) throws Exception {
        ObjectName framework = JMXBundleDeployer.getFramework(this.mBeanServerConnection);
        Object[] objects = new Object[]{id};
        String[] params = new String[]{"long"};
        this.mBeanServerConnection.invoke(framework, "uninstallBundle", objects, params);
    }

    /*
     * Exception decompiling
     */
    static String getLocalConnectorAddress() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ClassLoader getToolsClassLoader(ClassLoader parent) throws IOException {
        File toolsJar = JMXBundleDeployer.findJdkJar("tools.jar");
        if (toolsJar != null && toolsJar.exists()) {
            URL toolsUrl = null;
            try {
                toolsUrl = toolsJar.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
            URL[] urls = new URL[]{toolsUrl};
            return new URLClassLoader(urls, parent);
        }
        return null;
    }

    static File findJdkJar(String jar) throws IOException {
        File retval = null;
        String jarPath = String.valueOf(File.separator) + "lib" + File.separator + jar;
        String javaHome = System.getProperty("java.home");
        File jarFile = new File(String.valueOf(javaHome) + jarPath);
        if (jarFile.exists()) {
            retval = jarFile;
        } else {
            jarFile = new File(String.valueOf(javaHome) + "/.." + jarPath);
            if (jarFile.exists()) {
                retval = jarFile.getCanonicalFile();
            }
        }
        return retval;
    }
}

