/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor;

import com.liferay.ide.portlet.ui.PortletUIPlugin;
import com.liferay.ide.ui.util.UIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class MessageKeyHyperlink
implements IHyperlink {
    private final IFile file;
    private final String key;
    private final int length;
    private final int offset;
    private final IRegion region;

    public MessageKeyHyperlink(IRegion region, IFile file, String key, int offset, int length) {
        this.region = region;
        this.file = file;
        this.key = key;
        this.offset = offset;
        this.length = length;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return "Open '" + this.key + "' in " + this.file.getName();
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        try {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)UIUtil.getActivePage(), (IFile)this.file, (boolean)true);
            if (editorPart instanceof AbstractTextEditor) {
                AbstractTextEditor editor = (AbstractTextEditor)editorPart;
                editor.selectAndReveal(this.offset, this.length);
            }
        }
        catch (PartInitException e) {
            PortletUIPlugin.logError("Could not open properties file " + this.file.getName(), (Exception)((Object)e));
        }
    }
}

