/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.ui.editor.internal;

import com.liferay.ide.portlet.core.model.Portlet;
import com.liferay.ide.portlet.core.model.PortletInfo;
import com.liferay.ide.portlet.core.model.SupportedLocales;
import com.liferay.ide.portlet.core.model.internal.LocaleBundleValidationService;
import com.liferay.ide.portlet.core.util.PortletUtil;
import com.liferay.ide.portlet.ui.editor.internal.AbstractResourceBundleActionHandler;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.ui.texteditor.ITextEditor;

public class CreatePortletResourceBundleActionHandler
extends AbstractResourceBundleActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        Element element = this.getModelElement();
        this.listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                CreatePortletResourceBundleActionHandler.this.refreshEnablementState();
            }
        };
        element.attach(this.listener, this.property().name());
        element.attach(this.listener, Portlet.PROP_SUPPORTED_LOCALES.name());
        element.attach(this.listener, String.valueOf(Portlet.PROP_SUPPORTED_LOCALES.name()) + "/" + SupportedLocales.PROP_SUPPORTED_LOCALE.name());
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    CreatePortletResourceBundleActionHandler.this.getModelElement().detach(CreatePortletResourceBundleActionHandler.this.listener, CreatePortletResourceBundleActionHandler.this.property().name());
                    CreatePortletResourceBundleActionHandler.this.getModelElement().detach(CreatePortletResourceBundleActionHandler.this.listener, Portlet.PROP_SUPPORTED_LOCALES.name());
                    CreatePortletResourceBundleActionHandler.this.getModelElement().detach(CreatePortletResourceBundleActionHandler.this.listener, String.valueOf(Portlet.PROP_SUPPORTED_LOCALES.name()) + "/" + SupportedLocales.PROP_SUPPORTED_LOCALE.name());
                }
            }
        });
    }

    @Override
    protected boolean computeEnablementState() {
        boolean isEnabled = super.computeEnablementState();
        if (isEnabled) {
            Portlet portlet = (Portlet)this.getModelElement();
            if (portlet.getResourceBundle() != null && !portlet.getResourceBundle().empty() && portlet.getResourceBundle().validation().severity() == Status.Severity.ERROR) {
                isEnabled = false;
            }
            if (portlet.getSupportedLocales() != null && !portlet.getSupportedLocales().isEmpty()) {
                for (SupportedLocales sl : portlet.getSupportedLocales()) {
                    if (sl.validation().severity() != Status.Severity.ERROR) continue;
                    isEnabled = false;
                    break;
                }
            }
        }
        return isEnabled;
    }

    protected Object run(Presentation context) {
        ((ITextEditor)context.part().adapt(ITextEditor.class)).doSave((IProgressMonitor)new NullProgressMonitor());
        ArrayList<IFile> missingRBFiles = new ArrayList<IFile>();
        Portlet portlet = (Portlet)this.getModelElement();
        IProject project = (IProject)portlet.adapt(IProject.class);
        Value resourceBundle = portlet.getResourceBundle();
        String text = resourceBundle.text();
        String defaultRBFileName = PortletUtil.convertJavaToIoFileName((String)text, (String)"properties", (String[])new String[0]);
        int index = text.lastIndexOf(".");
        String packageName = "";
        if (index == -1) {
            index = text.length();
            packageName = "";
        } else {
            packageName = text.substring(0, index);
        }
        IFolder rbSourceFolder = this.getResourceBundleFolderLocation(project, defaultRBFileName);
        IPath entryPath = rbSourceFolder.getLocation();
        PortletInfo portletInfo = portlet.getPortletInfo();
        StringBuilder rbFileBuffer = this.buildDefaultRBContent(portletInfo);
        if (!this.getFileFromClasspath(project, defaultRBFileName)) {
            IFile drbFile = this.wroot.getFileForLocation(entryPath.append(defaultRBFileName));
            missingRBFiles.add(drbFile);
        }
        ElementList supportedLocales = portlet.getSupportedLocales();
        for (SupportedLocales iSupportedLocale : supportedLocales) {
            if (iSupportedLocale == null) continue;
            String locale = PortletUtil.localeString((String)iSupportedLocale.getSupportedLocale().text());
            String localizedIOFileName = PortletUtil.convertJavaToIoFileName((String)text, (String)"properties", (String[])new String[]{locale});
            if (this.getFileFromClasspath(project, localizedIOFileName)) continue;
            IFile rbFile = this.wroot.getFileForLocation(entryPath.append(localizedIOFileName));
            missingRBFiles.add(rbFile);
        }
        this.createFiles(context, project, packageName, missingRBFiles, rbFileBuffer);
        this.setEnabled(false);
        for (SupportedLocales sl : ((Portlet)this.getModelElement().nearest(Portlet.class)).getSupportedLocales()) {
            ((LocaleBundleValidationService)sl.getSupportedLocale().service(LocaleBundleValidationService.class)).forceRefresh();
        }
        return null;
    }

    private StringBuilder buildDefaultRBContent(PortletInfo portletInfo) {
        StringBuilder rbFileBuffer = new StringBuilder();
        rbFileBuffer.append("#Portlet Information\n");
        rbFileBuffer.append("javax.portlet.title");
        rbFileBuffer.append("=");
        rbFileBuffer.append(portletInfo != null && portletInfo.getTitle() != null ? portletInfo.getTitle() : "");
        rbFileBuffer.append("\n");
        rbFileBuffer.append("javax.portlet.short-title");
        rbFileBuffer.append("=");
        rbFileBuffer.append(portletInfo != null && portletInfo.getShortTitle() != null ? portletInfo.getShortTitle() : "");
        rbFileBuffer.append("\n");
        rbFileBuffer.append("javax.portlet.keywords");
        rbFileBuffer.append("=");
        rbFileBuffer.append(portletInfo != null && portletInfo.getKeywords() != null ? portletInfo.getKeywords() : "");
        rbFileBuffer.append("\n");
        rbFileBuffer.append("#Other Properties");
        rbFileBuffer.append("\n");
        return rbFileBuffer;
    }
}

