/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.XmlAdapter;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlAdapter;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;

public abstract class AbstractJavaXmlJavaTypeAdapter
extends AbstractJavaContextNode
implements XmlJavaTypeAdapter {
    protected final XmlJavaTypeAdapterAnnotation annotation;
    protected String value;
    protected XmlAdapter xmlAdapter;
    protected String specifiedType;
    protected String defaultType;

    protected AbstractJavaXmlJavaTypeAdapter(JaxbContextNode parent, XmlJavaTypeAdapterAnnotation annotation) {
        super(parent);
        this.annotation = annotation;
        this.value = this.getResourceValue();
        this.initializeXmlAdapter();
        this.specifiedType = this.getResourceTypeString();
        this.defaultType = this.buildDefaultType();
    }

    public XmlJavaTypeAdapterAnnotation getAnnotation() {
        return this.annotation;
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setValue_(this.getResourceValue());
        this.syncXmlAdapter();
        this.setSpecifiedType_(this.getResourceTypeString());
        this.setDefaultType(this.buildDefaultType());
    }

    public void update() {
        super.update();
        this.updateXmlAdapter();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.annotation.setValue(value);
        this.setValue_(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, value);
    }

    protected String getResourceValue() {
        return this.annotation.getValue();
    }

    public String getFullyQualifiedValue() {
        return this.annotation.getFullyQualifiedValue();
    }

    public XmlAdapter getXmlAdapter() {
        return this.xmlAdapter;
    }

    protected void setXmlAdapter_(XmlAdapter xmlAdapter) {
        XmlAdapter old = this.xmlAdapter;
        this.xmlAdapter = xmlAdapter;
        this.firePropertyChanged("xmlAdapter", old, xmlAdapter);
    }

    protected JavaResourceType getXmlAdapterResourceType() {
        String xmlAdapterName = this.getFullyQualifiedValue();
        return (JavaResourceType)this.getJaxbProject().getJavaResourceType(xmlAdapterName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
    }

    protected XmlAdapter buildXmlAdapter(JavaResourceType xmlAdapterResourceType) {
        return new GenericJavaXmlAdapter(this, xmlAdapterResourceType);
    }

    protected void initializeXmlAdapter() {
        JavaResourceType xmlAdapterResourceType = this.getXmlAdapterResourceType();
        if (xmlAdapterResourceType != null) {
            this.xmlAdapter = this.buildXmlAdapter(xmlAdapterResourceType);
        }
    }

    protected void syncXmlAdapter() {
        if (this.xmlAdapter != null) {
            this.xmlAdapter.synchronizeWithResourceModel();
        }
    }

    protected void updateXmlAdapter() {
        JavaResourceType newResourceType = this.getXmlAdapterResourceType();
        if (newResourceType == null) {
            this.setXmlAdapter_(null);
        } else if (this.xmlAdapter == null) {
            this.setXmlAdapter_(this.buildXmlAdapter(newResourceType));
        } else {
            JavaResourceType currentResourceType = this.xmlAdapter.getJavaResourceType();
            if (currentResourceType == null || !currentResourceType.equals(newResourceType)) {
                this.setXmlAdapter_(this.buildXmlAdapter(newResourceType));
            } else {
                this.xmlAdapter.update();
            }
        }
    }

    public String getType() {
        return this.specifiedTypeNotSet() ? this.getDefaultType() : this.getSpecifiedType();
    }

    protected boolean specifiedTypeNotSet() {
        return this.getSpecifiedType() == null || this.annotation.getFullyQualifiedType().equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT");
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType(String defaultType) {
        String oldDefaultType = this.defaultType;
        this.defaultType = defaultType;
        this.firePropertyChanged("defaultType", oldDefaultType, defaultType);
    }

    protected abstract String buildDefaultType();

    public String getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(String location) {
        this.annotation.setType(location);
        this.setSpecifiedType_(location);
    }

    protected void setSpecifiedType_(String type) {
        String old = this.specifiedType;
        this.specifiedType = type;
        this.firePropertyChanged("specifiedType", old, type);
    }

    protected String getResourceTypeString() {
        return this.annotation.getType();
    }

    public String getFullyQualifiedType() {
        return this.specifiedTypeNotSet() ? this.getDefaultType() : this.annotation.getFullyQualifiedType();
    }

    public TextRange getValidationTextRange() {
        return this.annotation.getTextRange();
    }
}

