/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.project.core.model.LiferayPluginSDKOp;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.ILiferayRuntime;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.service.prefs.BackingStoreException;

public class LiferayProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IPluginProjectDataModelProperties {
    private Combo runtimeCombo;
    private Text sdkLabel;

    public LiferayProjectPropertyPage() {
        this.setImageDescriptor(ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/liferay.png"));
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite top = SWTUtil.createTopComposite((Composite)parent, (int)3);
        this.createInfoGroup(top);
        return top;
    }

    protected Group createDefaultGroup(Composite parent, String text, int columns) {
        GridLayout gl = new GridLayout(columns, false);
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)gl);
        return group;
    }

    public boolean performOk() {
        IProject proj = this.getProject();
        if (SDKUtil.isSDKProject((IProject)proj)) {
            String sdkName;
            String selectedRuntimeName;
            if (this.runtimeCombo != null && !CoreUtil.isNullOrEmpty((String)(selectedRuntimeName = this.runtimeCombo.getText()))) {
                final org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = RuntimeManager.getRuntime((String)selectedRuntimeName);
                if (runtime != null) {
                    final IFacetedProject fProject = ProjectUtil.getFacetedProject((IProject)this.getProject());
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime = fProject.getPrimaryRuntime();
                    if (!runtime.equals(primaryRuntime)) {
                        WorkspaceJob job = new WorkspaceJob("Setting targeted runtime for project."){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                IStatus retval = Status.OK_STATUS;
                                try {
                                    fProject.setTargetedRuntimes(Collections.singleton(runtime), monitor);
                                    fProject.setPrimaryRuntime(runtime, monitor);
                                }
                                catch (Exception e) {
                                    retval = ProjectUI.createErrorStatus("Could not set targeted runtime", e);
                                }
                                return retval;
                            }
                        };
                        job.schedule();
                    }
                } else {
                    return false;
                }
            }
            if (!CoreUtil.isNullOrEmpty((String)(sdkName = this.sdkLabel.getText()))) {
                try {
                    IEclipsePreferences prefs = new ProjectScope(this.getProject()).getNode("com.liferay.ide.sdk.core");
                    prefs.put("sdk-name", sdkName);
                    prefs.flush();
                }
                catch (BackingStoreException be) {
                    ProjectCore.logError((String)("Unable to persist sdk name to project " + this.getProject()), (Exception)((Object)be));
                }
            }
        }
        return true;
    }

    protected void createInfoGroup(Composite parent) {
        block14: {
            IProject proj;
            new Label(parent, 16384).setText(Msgs.liferayPluginTypeLabel);
            Text pluginTypeLabel = new Text(parent, 2056);
            pluginTypeLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            IProjectFacet liferayFacet = ProjectUtil.getLiferayFacet((IFacetedProject)this.getFacetedProject());
            if (liferayFacet != null) {
                pluginTypeLabel.setText(liferayFacet.getLabel());
            }
            if ((proj = this.getProject()) != null && ProjectUtil.isLiferayFacetedProject((IProject)proj)) {
                try {
                    if (ProjectUtil.isMavenProject((IProject)proj)) break block14;
                    SDK projectSdk = SDKUtil.getSDK((IProject)this.getProject());
                    new Label(parent, 16384).setText(Msgs.liferaySdkLabel);
                    this.sdkLabel = new Text(parent, 2056);
                    if (projectSdk != null) {
                        this.sdkLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                        this.sdkLabel.setText(projectSdk.getName());
                    } else {
                        this.sdkLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
                        this.sdkLabel.setText("");
                        Hyperlink link = new Hyperlink(parent, 0);
                        link.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
                        link.setForeground(parent.getDisplay().getSystemColor(9));
                        link.setUnderlined(true);
                        link.setText(Msgs.changeliferaySdk);
                        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent e) {
                                LiferayPluginSDKOp op = (LiferayPluginSDKOp)LiferayPluginSDKOp.TYPE.instantiate().initialize();
                                DefinitionLoader.Reference dialogRef = DefinitionLoader.context((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).sdef("com.liferay.ide.project.ui.dialog.SelectPluginsSDKDialog").dialog("ConfigureLiferaySDK");
                                SapphireDialog dialog = new SapphireDialog(UIUtil.getActiveShell(), (Element)op, dialogRef);
                                dialog.setBlockOnOpen(true);
                                int result = dialog.open();
                                if (result != 1) {
                                    LiferayProjectPropertyPage.this.sdkLabel.setText((String)op.getPluginsSDKName().content());
                                }
                            }
                        });
                    }
                    new Label(parent, 16384).setText(Msgs.liferayRuntimeLabel);
                    this.runtimeCombo = new Combo(parent, 12);
                    this.runtimeCombo.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                    String currentRuntimeName = null;
                    try {
                        ILiferayRuntime liferayRuntime = ServerUtil.getLiferayRuntime((IProject)this.getProject());
                        if (liferayRuntime != null) {
                            currentRuntimeName = liferayRuntime.getRuntime().getName();
                        }
                    }
                    catch (Exception e) {
                        ProjectUI.logError("Could not determine liferay runtime", e);
                    }
                    ArrayList<String> runtimeNames = new ArrayList<String>();
                    int selectionIndex = -1;
                    IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
                    int n = iRuntimeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRuntime runtime = iRuntimeArray[n2];
                        if (ServerUtil.isLiferayRuntime((IRuntime)runtime)) {
                            runtimeNames.add(runtime.getName());
                            if (runtime.getName().equals(currentRuntimeName)) {
                                selectionIndex = runtimeNames.size() - 1;
                            }
                        }
                        ++n2;
                    }
                    if (runtimeNames.size() == 0) {
                        runtimeNames.add("No Liferay runtimes available.");
                    }
                    this.runtimeCombo.setItems(runtimeNames.toArray(new String[0]));
                    if (selectionIndex > -1) {
                        this.runtimeCombo.select(selectionIndex);
                    }
                }
                catch (Exception e) {
                    ProjectUI.logError("Could not determine whether its a maven project ", e);
                }
            }
        }
    }

    protected IFacetedProject getFacetedProject() {
        IFacetedProject retval = null;
        IProject project = this.getProject();
        if (project != null) {
            retval = ProjectUtil.getFacetedProject((IProject)project);
        }
        return retval;
    }

    protected IProject getProject() {
        IAdaptable adaptable = this.getElement();
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        return project;
    }

    private static class Msgs
    extends NLS {
        public static String liferayPluginTypeLabel;
        public static String liferayRuntimeLabel;
        public static String liferaySdkLabel;
        public static String changeliferaySdk;

        static {
            Msgs.initializeMessages((String)LiferayProjectPropertyPage.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

