/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.dialog.JavaProjectSelectionDialog;
import com.liferay.ide.ui.util.UIUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class RunMigrationToolAction
extends Action {
    private Shell shell;

    public RunMigrationToolAction(String text, Shell shell) {
        super(text);
        this.shell = shell;
        this.setImageDescriptor(ProjectUI.getDefault().getImageRegistry().getDescriptor("migration.tasks.image"));
    }

    public void run() {
        Object[] selectedProjects;
        JavaProjectSelectionDialog dialog = new JavaProjectSelectionDialog(this.shell);
        if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
            IJavaProject javaProject = (IJavaProject)selectedProjects[0];
            StructuredSelection selection = new StructuredSelection((Object)javaProject.getProject());
            try {
                UIUtil.executeCommand((String)"com.liferay.ide.project.ui.migrateProject", (ISelection)selection);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                ProjectUI.createErrorStatus("Error in migrate command", (Exception)e);
            }
        }
    }
}

