/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.model.ProjectName;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.wizard.WorkingSetCustomPart;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.WizardPagePart;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.web.internal.DelegateConfigurationElement;

public class NewLiferayModuleProjectWizard
extends SapphireWizard<NewLiferayModuleProjectOp>
implements IWorkbenchWizard,
INewWizard {
    private boolean firstErrorMessageRemoved = false;

    public NewLiferayModuleProjectWizard() {
        super((Element)NewLiferayModuleProjectWizard.createDefaultOp(), DefinitionLoader.sdef(NewLiferayModuleProjectWizard.class).wizard());
    }

    private void addToWorkingSets(IProject newProject) throws Exception {
        if (newProject != null) {
            for (FormComponentPart formPart : ((WizardPagePart)this.part().getPages().get(0)).children().all()) {
                WorkingSetCustomPart workingSetPart;
                Object[] workingSets;
                if (!(formPart instanceof WorkingSetCustomPart) || CoreUtil.isNullOrEmpty((Object[])(workingSets = (workingSetPart = (WorkingSetCustomPart)formPart).getWorkingSets()))) continue;
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newProject, (IWorkingSet[])workingSets);
            }
        }
    }

    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (!this.firstErrorMessageRemoved && wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            String message = wizardPage.getMessage();
            int messageType = wizardPage.getMessageType();
            if (messageType == 3 && !CoreUtil.isNullOrEmpty((String)message)) {
                wizardPage.setMessage("Please enter a project name.", 0);
                this.firstErrorMessageRemoved = true;
            }
        }
        return wizardPages;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private void openLiferayPerspective(IProject newProject) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        DelegateConfigurationElement element = new DelegateConfigurationElement(null){

            public String getAttribute(String aName) {
                if (aName.equals("finalPerspective")) {
                    return "com.liferay.ide.eclipse.ui.perspective.liferay";
                }
                return super.getAttribute(aName);
            }
        };
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
        BasicNewResourceWizard.selectAndReveal((IResource)newProject, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
    }

    protected void performPostFinish() {
        super.performPostFinish();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        NewLiferayModuleProjectOp op = (NewLiferayModuleProjectOp)((NewLiferayModuleProjectOp)this.element()).nearest(NewLiferayModuleProjectOp.class);
        ElementList projectNames = op.getProjectNames();
        for (ProjectName projectName : projectNames) {
            IProject newProject = CoreUtil.getProject((String)((String)projectName.getName().content()));
            if (newProject == null) continue;
            projects.add(newProject);
        }
        for (IProject project : projects) {
            try {
                this.addToWorkingSets(project);
            }
            catch (Exception ex) {
                ProjectUI.logError("Unable to add project to working set", ex);
            }
        }
        if (projects.size() > 0) {
            IProject finalProject = (IProject)projects.get(0);
            this.openLiferayPerspective(finalProject);
        }
    }

    private static NewLiferayModuleProjectOp createDefaultOp() {
        return (NewLiferayModuleProjectOp)NewLiferayModuleProjectOp.TYPE.instantiate();
    }
}

