/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalClosure<A>
implements Closure<A> {
    private final Predicate<? super A> predicate;
    private final Closure<? super A> trueClosure;
    private final Closure<? super A> falseClosure;

    public ConditionalClosure(Predicate<? super A> predicate, Closure<? super A> trueClosure, Closure<? super A> falseClosure) {
        if (predicate == null || trueClosure == null || falseClosure == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.trueClosure = trueClosure;
        this.falseClosure = falseClosure;
    }

    @Override
    public void execute(A argument) {
        if (this.predicate.evaluate(argument)) {
            this.trueClosure.execute(argument);
        } else {
            this.falseClosure.execute(argument);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.predicate);
    }
}

