/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFieldFactory<T>
implements Factory<T> {
    private final Field field;

    public StaticFieldFactory(Field field) {
        if (field == null) {
            throw new NullPointerException();
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("field must be static: " + field);
        }
        if (!field.isAccessible()) {
            throw new IllegalArgumentException("field must be accessible: " + field);
        }
        this.field = field;
    }

    @Override
    public T create() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.field);
    }
}

