/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterable<E>
implements Iterable<E> {
    final E[] array;
    final int start;
    final int end;

    public ArrayIterable(E[] array, int start, int end) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (end < start || end > array.length) {
            throw new IllegalArgumentException("end: " + end);
        }
        this.array = array;
        this.start = start;
        this.end = end;
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorTools.iterator(this.array, this.start, this.end);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

