/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.alloy.core.webresources;

import com.liferay.ide.alloy.core.AlloyCore;
import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.html.webresources.core.providers.IWebResourcesContext;
import org.eclipse.wst.html.webresources.core.providers.IWebResourcesFileSystemProvider;

public class PortalResourcesProvider
implements IWebResourcesFileSystemProvider {
    private static final Map<IPath, Collection<File>> fileCache = new WeakHashMap<IPath, Collection<File>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getResources(IWebResourcesContext context) {
        File[] retval = null;
        IFile htmlFile = context.getHtmlFile();
        ILiferayProject project = LiferayCore.create((Object)htmlFile.getProject());
        if (htmlFile != null && project != null) {
            ILiferayPortal portal = (ILiferayPortal)project.adapt(ILiferayPortal.class);
            if (portal != null && ProjectUtil.isPortletProject((IProject)htmlFile.getProject())) {
                IPath cssPath;
                IPath portalDir = portal.getAppServerPortalDir();
                if (portalDir != null && (cssPath = portalDir.append("html/themes/_unstyled/css")).toFile().exists()) {
                    Map<IPath, Collection<File>> map = fileCache;
                    synchronized (map) {
                        Collection<File> cachedFiles = fileCache.get(cssPath);
                        if (cachedFiles != null) {
                            retval = cachedFiles.toArray(new File[0]);
                        } else {
                            Collection files = FileUtils.listFiles((File)cssPath.toFile(), (String[])new String[]{"css", "scss"}, (boolean)true);
                            HashSet<File> cached = new HashSet<File>();
                            for (File file : files) {
                                File cachedFile;
                                if (!file.getName().endsWith("scss") || !(cachedFile = new File(file.getParent(), ".sass-cache/" + file.getName().replaceAll("scss$", "css"))).exists()) continue;
                                cached.add(file);
                            }
                            files.removeAll(cached);
                            if (files != null) {
                                retval = files.toArray(new File[0]);
                            }
                            fileCache.put(cssPath, files);
                        }
                    }
                }
            } else if (portal != null && ProjectUtil.isLayoutTplProject((IProject)htmlFile.getProject())) {
                String version = portal.getVersion();
                try {
                    if (version != null && (version.startsWith("6.0") || version.startsWith("6.1"))) {
                        retval = this.createLayoutHelperFiles("resources/layouttpl-6.1.css");
                    } else if (version != null) {
                        retval = this.createLayoutHelperFiles("resources/layouttpl-6.2.css");
                    }
                }
                catch (IOException e) {
                    AlloyCore.logError("Unable to load layout template helper css files", e);
                }
            }
        }
        return retval;
    }

    private File[] createLayoutHelperFiles(String path) throws IOException {
        URL url = FileLocator.toFileURL((URL)AlloyCore.getDefault().getBundle().getEntry(path));
        return new File[]{new File(url.getFile())};
    }
}

