/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.AbstractMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.DomainLoadingStrategyRegistry;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;

public final class MetaDataModelManager
extends AbstractMetaDataModelManager {
    private static IMetaDataModelManager SHARED_INSTANCE;
    private static final Lock GLOBAL_INSTANCE_LOCK;
    private final ModelMap models = new ModelMap();

    static {
        GLOBAL_INSTANCE_LOCK = new ReentrantLock();
    }

    public static synchronized IMetaDataModelManager getSharedInstance() {
        if (SHARED_INSTANCE == null) {
            SHARED_INSTANCE = new MetaDataModelManager(null);
        }
        return SHARED_INSTANCE;
    }

    MetaDataModelManager(IProject project) {
    }

    public Model getModel(IMetaDataModelContext modelContext) {
        boolean gotLock = false;
        try {
            int numTries = 0;
            Job currentJob = Job.getJobManager().currentJob();
            while (numTries < 6 && !(gotLock = GLOBAL_INSTANCE_LOCK.tryLock(5000L, TimeUnit.MILLISECONDS))) {
                ++numTries;
                if (currentJob == null) continue;
                currentJob.yieldRule(null);
            }
            if (!gotLock) {
                return null;
            }
            IMetaDataModelContext context = Aliases.get(modelContext);
            StandardModelFactory.debug(">START getModel: " + context, StandardModelFactory.DEBUG_MD_GET);
            MetaDataModel model = this.models.get(context);
            if (model == null) {
                model = this.loadMetadata(context);
            } else if (model.needsRefresh()) {
                try {
                    model.reload();
                }
                catch (ModelNotSetException modelNotSetException) {
                    model = this.loadMetadata(context);
                }
            }
            StandardModelFactory.debug(">END getModel: " + context, StandardModelFactory.DEBUG_MD_GET);
            if (model != null && !model.isEmpty()) {
                Model model2 = (Model)model.getRoot();
                return model2;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        finally {
            if (gotLock) {
                GLOBAL_INSTANCE_LOCK.unlock();
            }
        }
    }

    private MetaDataModel loadMetadata(IMetaDataModelContext context) {
        IDomainLoadingStrategy strategy = DomainLoadingStrategyRegistry.getInstance().getLoadingStrategy(context.getDomainId());
        if (strategy == null) {
            JSFCommonPlugin.log(4, "Internal Error: Unable to locate metadata loading strategy for: " + context.toString());
            return null;
        }
        MetaDataModel model = StandardModelFactory.getInstance().createModel(context, strategy);
        model.load();
        this.addModel(model);
        return model;
    }

    private void addModel(MetaDataModel model) {
        if (model != null) {
            this.models.put(model);
        }
    }

    public void dispose() {
        super.dispose();
        this.models.dispose();
    }

    public void destroy() {
        this.dispose();
    }

    private static class Aliases {
        private static final HashMap<String, String> aliasMap = new HashMap(6);

        static {
            aliasMap.put("http://xmlns.jcp.org/jsf/composite", "http://java.sun.com/jsf/composite");
            aliasMap.put("http://xmlns.jcp.org/jsf/core", "http://java.sun.com/jsf/core");
            aliasMap.put("http://xmlns.jcp.org/jsf/html", "http://java.sun.com/jsf/html");
            aliasMap.put("http://xmlns.jcp.org/jsf/jstl/core", "http://java.sun.com/jsf/jstl/core");
            aliasMap.put("http://xmlns.jcp.org/jsf/jstl/functions", "http://java.sun.com/jsf/jstl/functions");
            aliasMap.put("http://xmlns.jcp.org/jsf/facelets", "http://java.sun.com/jsf/facelets");
        }

        private Aliases() {
        }

        private static IMetaDataModelContext get(IMetaDataModelContext context) {
            String alias;
            IMetaDataModelContext copy = context;
            if (context instanceof MetaDataModelContext && (alias = aliasMap.get(context.getModelIdentifier())) != null) {
                copy = new MetaDataModelContext((IProject)context.getAdapter(IProject.class), context.getDomainId(), alias);
            }
            return copy;
        }
    }

    private static class ModelMap {
        final Map<String, MetaDataModel> map;
        private final AtomicBoolean _isDisposed = new AtomicBoolean(false);

        ModelMap() {
            this.map = new HashMap<String, MetaDataModel>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(MetaDataModel model) {
            assert (!this._isDisposed.get());
            String key = this.calculateKey(model);
            ModelMap modelMap = this;
            synchronized (modelMap) {
                this.map.put(key, model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetaDataModel get(IMetaDataModelContext context) {
            assert (!this._isDisposed.get());
            String key = this.calculateKey(context);
            ModelMap modelMap = this;
            synchronized (modelMap) {
                return this.map.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this._isDisposed.compareAndSet(false, true)) {
                ModelMap modelMap = this;
                synchronized (modelMap) {
                    Iterator<Map.Entry<String, MetaDataModel>> it = this.map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, MetaDataModel> entry = it.next();
                        MetaDataModel model = entry.getValue();
                        if (model != null) {
                            model.cleanup();
                        }
                        it.remove();
                    }
                }
            }
        }

        private String calculateKey(MetaDataModel model) {
            return this.calculateKey(model.getModelContext());
        }

        private String calculateKey(IMetaDataModelContext context) {
            StringBuffer buf = new StringBuffer(context.getDomainId()).append(":").append(context.getModelIdentifier());
            return buf.toString();
        }
    }
}

