/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.GenerationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceGeneratedValueAnnotation
extends SourceAnnotation
implements GeneratedValueAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.GeneratedValue");
    private static final DeclarationAnnotationElementAdapter<String> STRATEGY_ADAPTER = SourceGeneratedValueAnnotation.buildStrategyAdapter();
    private final AnnotationElementAdapter<String> strategyAdapter;
    private GenerationType strategy;
    private TextRange strategyTextRange;
    private static final DeclarationAnnotationElementAdapter<String> GENERATOR_ADAPTER = SourceGeneratedValueAnnotation.buildGeneratorAdapter();
    private final AnnotationElementAdapter<String> generatorAdapter;
    private String generator;
    private TextRange generatorTextRange;

    public SourceGeneratedValueAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceModel)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.strategyAdapter = new AnnotatedElementAnnotationElementAdapter(element, STRATEGY_ADAPTER);
        this.generatorAdapter = new AnnotatedElementAnnotationElementAdapter(element, GENERATOR_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.GeneratedValue";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.strategy = this.buildStrategy(astAnnotation);
        this.strategyTextRange = this.buildStrategyTextRange(astAnnotation);
        this.generator = this.buildGenerator(astAnnotation);
        this.generatorTextRange = this.buildGeneratorTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncStrategy(this.buildStrategy(astAnnotation));
        this.strategyTextRange = this.buildStrategyTextRange(astAnnotation);
        this.syncGenerator(this.buildGenerator(astAnnotation));
        this.generatorTextRange = this.buildGeneratorTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.strategy == null && this.generator == null;
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.strategy);
    }

    @Override
    public GenerationType getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(GenerationType strategy) {
        if (ObjectTools.notEquals((Object)((Object)this.strategy), (Object)((Object)strategy))) {
            this.strategy = strategy;
            this.strategyAdapter.setValue((Object)GenerationType.toJavaAnnotationValue(strategy));
        }
    }

    private void syncStrategy(GenerationType astStrategy) {
        GenerationType old = this.strategy;
        this.strategy = astStrategy;
        this.firePropertyChanged("strategy", (Object)old, (Object)astStrategy);
    }

    private GenerationType buildStrategy(Annotation astAnnotation) {
        return GenerationType.fromJavaAnnotationValue(this.strategyAdapter.getValue(astAnnotation));
    }

    @Override
    public TextRange getStrategyTextRange() {
        return this.strategyTextRange;
    }

    private TextRange buildStrategyTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(STRATEGY_ADAPTER, astAnnotation);
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public void setGenerator(String generator) {
        if (ObjectTools.notEquals((Object)this.generator, (Object)generator)) {
            this.generator = generator;
            this.generatorAdapter.setValue((Object)generator);
        }
    }

    private void syncGenerator(String astGenerator) {
        String old = this.generator;
        this.generator = astGenerator;
        this.firePropertyChanged("generator", old, astGenerator);
    }

    private String buildGenerator(Annotation astAnnotation) {
        return (String)this.generatorAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getGeneratorTextRange() {
        return this.generatorTextRange;
    }

    private TextRange buildGeneratorTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(GENERATOR_ADAPTER, astAnnotation);
    }

    @Override
    public boolean generatorTouches(int pos) {
        return this.textRangeTouches(this.generatorTextRange, pos);
    }

    private static DeclarationAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "strategy");
    }

    private static DeclarationAnnotationElementAdapter<String> buildGeneratorAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"generator");
    }
}

