/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessorType;
import org.eclipse.wst.xml.search.core.xpath.XPathProcessorManager;
import org.eclipse.wst.xml.search.ui.internal.Messages;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchUIPlugin;
import org.eclipse.wst.xml.search.ui.internal.preferences.AbstractTableBlock;

public class InstalledProcessorsBlock
extends AbstractTableBlock
implements ISelectionProvider {
    private Composite fControl;
    private final List<IXPathProcessorType> processors = new ArrayList<IXPathProcessorType>();
    private CheckboxTableViewer tableViewer;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private final ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.tableViewer.getCheckedElements());
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object jre = ((IStructuredSelection)selection).getFirstElement();
            if (jre == null) {
                this.tableViewer.setCheckedElements(new Object[0]);
            } else {
                this.tableViewer.setCheckedElements(new Object[]{jre});
                this.tableViewer.reveal(jre);
            }
            this.fireSelectionChanged();
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(Messages.InstalledProcessorsBlock_0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        tableLabel.setFont(font);
        Table fTable = new Table(parent, 68128);
        data = new GridData(1808);
        data.widthHint = 450;
        fTable.setLayoutData((Object)data);
        fTable.setFont(font);
        fTable.setHeaderVisible(true);
        fTable.setLinesVisible(true);
        TableColumn column1 = new TableColumn(fTable, 0);
        column1.setWidth(180);
        column1.setResizable(true);
        column1.setText(Messages.InstalledProcessorsBlock_1);
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledProcessorsBlock.this.sortByName();
            }
        });
        TableColumn column2 = new TableColumn(fTable, 0);
        column2.setWidth(180);
        column2.setResizable(true);
        column2.setText(Messages.InstalledProcessorsBlock_2);
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledProcessorsBlock.this.sortBySource();
            }
        });
        this.tableViewer = new CheckboxTableViewer(fTable);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new VMLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ProcessorsContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledProcessorsBlock.this.enableButtons();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InstalledProcessorsBlock.this.setCheckedInstall((IXPathProcessorType)event.getElement());
                } else {
                    InstalledProcessorsBlock.this.setCheckedInstall(null);
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InstalledProcessorsBlock.this.tableViewer.getSelection().isEmpty()) {
                    InstalledProcessorsBlock.this.editProcessor();
                }
            }
        });
        fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    InstalledProcessorsBlock.this.removeProcessors();
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.fAddButton = this.createPushButton(buttons, Messages.InstalledProcessorsBlock_5);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledProcessorsBlock.this.addProcessor();
            }
        });
        this.fAddButton.setEnabled(false);
        this.fEditButton = this.createPushButton(buttons, Messages.InstalledProcessorsBlock_6);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledProcessorsBlock.this.editProcessor();
            }
        });
        this.fRemoveButton = this.createPushButton(buttons, Messages.InstalledProcessorsBlock_7);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledProcessorsBlock.this.removeProcessors();
            }
        });
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fillWithWorkspaceProcessors();
        this.enableButtons();
        this.restoreColumnSettings();
    }

    protected void fillWithWorkspaceProcessors() {
        this.setProcessors(XPathProcessorManager.getDefault().getProcessors());
    }

    private void fireSelectionChanged() {
        Object[] listeners;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = listeners = this.fSelectionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ISelectionChangedListener listener = (ISelectionChangedListener)element;
            listener.selectionChanged(event);
            ++n2;
        }
    }

    private void sortBySource() {
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IXPathProcessorType left = (IXPathProcessorType)e1;
                IXPathProcessorType right = (IXPathProcessorType)e2;
                return left.getSource().compareToIgnoreCase(right.getSource());
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
    }

    private void sortByName() {
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IXPathProcessorType && e2 instanceof IXPathProcessorType) {
                    IXPathProcessorType left = (IXPathProcessorType)e1;
                    IXPathProcessorType right = (IXPathProcessorType)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1 && !((IXPathProcessorType)selection.getFirstElement()).isContributed());
        if (selectionCount > 0 && selectionCount < this.tableViewer.getTable().getItemCount()) {
            for (IXPathProcessorType install : selection) {
                if (!install.isContributed()) continue;
                this.fRemoveButton.setEnabled(false);
                return;
            }
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        return button;
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setProcessors(IXPathProcessorType[] vms) {
        this.processors.clear();
        IXPathProcessorType[] iXPathProcessorTypeArray = vms;
        int n = vms.length;
        int n2 = 0;
        while (n2 < n) {
            IXPathProcessorType element = iXPathProcessorTypeArray[n2];
            this.processors.add(element);
            ++n2;
        }
        this.tableViewer.setInput(this.processors);
    }

    public IXPathProcessorType[] getProcessors() {
        return this.processors.toArray(new IXPathProcessorType[this.processors.size()]);
    }

    private void addProcessor() {
    }

    public void processorAdded(IXPathProcessorType install) {
        this.processors.add(install);
        this.tableViewer.add((Object)install);
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)install), true);
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.processors.size()) {
            IXPathProcessorType install = this.processors.get(i);
            if (install.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void editProcessor() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        IXPathProcessorType install = (IXPathProcessorType)selection.getFirstElement();
        if (install == null) {
            return;
        }
    }

    private void removeProcessors() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        IXPathProcessorType[] vms = new IXPathProcessorType[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            vms[i] = (IXPathProcessorType)iter.next();
            ++i;
        }
        this.removeProcessors(vms);
    }

    public void removeProcessors(IXPathProcessorType[] theInstalls) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        IXPathProcessorType[] iXPathProcessorTypeArray = theInstalls;
        int n = theInstalls.length;
        int n2 = 0;
        while (n2 < n) {
            IXPathProcessorType element = iXPathProcessorTypeArray[n2];
            this.processors.remove(element);
            ++n2;
        }
        this.tableViewer.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            IXPathProcessorType[] installs = this.getProcessors();
            if (curr.size() == 0 && installs.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)installs[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    public void setCheckedInstall(IXPathProcessorType install) {
        if (install == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)install));
        }
    }

    public IXPathProcessorType getCheckedInstall() {
        Object[] objects = this.tableViewer.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (IXPathProcessorType)objects[0];
    }

    @Override
    protected void setSortColumn(int column) {
        switch (column) {
            case 1: {
                this.sortByName();
            }
        }
        super.setSortColumn(column);
    }

    @Override
    protected Table getTable() {
        return this.tableViewer.getTable();
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        return XMLSearchUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    protected String getQualifier() {
        return "";
    }

    static /* synthetic */ List access$0(InstalledProcessorsBlock installedProcessorsBlock) {
        return installedProcessorsBlock.processors;
    }

    static /* synthetic */ void access$1(InstalledProcessorsBlock installedProcessorsBlock) {
        installedProcessorsBlock.sortByName();
    }

    static /* synthetic */ void access$2(InstalledProcessorsBlock installedProcessorsBlock) {
        installedProcessorsBlock.sortBySource();
    }

    static /* synthetic */ void access$3(InstalledProcessorsBlock installedProcessorsBlock) {
        installedProcessorsBlock.enableButtons();
    }

    static /* synthetic */ CheckboxTableViewer access$4(InstalledProcessorsBlock installedProcessorsBlock) {
        return installedProcessorsBlock.tableViewer;
    }

    static /* synthetic */ void access$5(InstalledProcessorsBlock installedProcessorsBlock) {
        installedProcessorsBlock.editProcessor();
    }

    static /* synthetic */ void access$6(InstalledProcessorsBlock installedProcessorsBlock) {
        installedProcessorsBlock.removeProcessors();
    }

    static /* synthetic */ void access$7(InstalledProcessorsBlock installedProcessorsBlock) {
        installedProcessorsBlock.addProcessor();
    }

    private class ProcessorsContentProvider
    implements IStructuredContentProvider {
        private ProcessorsContentProvider() {
        }

        public Object[] getElements(Object input) {
            return InstalledProcessorsBlock.this.processors.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class VMLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private VMLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IXPathProcessorType) {
                IXPathProcessorType install = (IXPathProcessorType)element;
                switch (columnIndex) {
                    case 0: {
                        return install.getName();
                    }
                    case 1: {
                        return install.getSource();
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

