/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.portlet.core.model.internal;

import com.liferay.ide.portlet.core.model.CustomWindowState;
import com.liferay.ide.portlet.core.model.WindowState;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ImageService;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyEvent;

public class WindowStateImageService
extends ImageService {
    private static final ImageData IMG_DEFAULT = (ImageData)ImageData.readFromClassLoader(WindowStateImageService.class, (String)"images/window_states.png").required();
    private static final ImageData IMG_MAXIMIZED = (ImageData)ImageData.readFromClassLoader(WindowStateImageService.class, (String)"images/maximize.png").required();
    private static final ImageData IMG_MINIMIZED = (ImageData)ImageData.readFromClassLoader(WindowStateImageService.class, (String)"images/minimize.png").required();
    private Listener listener;

    protected void initImageService() {
        this.listener = new FilteredListener<PropertyEvent>(){

            public void handleTypedEvent(PropertyEvent event) {
                WindowStateImageService.this.refresh();
            }
        };
        ((Element)this.context(Element.class)).attach(this.listener, WindowState.PROP_WINDOW_STATE.name());
    }

    protected ImageData compute() {
        String strWindowState = null;
        Element element = (Element)this.context(Element.class);
        ImageData imageData = null;
        if (element instanceof CustomWindowState) {
            CustomWindowState customWindowState = (CustomWindowState)element;
            strWindowState = String.valueOf(customWindowState.getWindowState().content());
        } else if (element instanceof WindowState) {
            WindowState windowState = (WindowState)element;
            strWindowState = (String)windowState.getWindowState().content();
        }
        if ("MAXIMIZED".equalsIgnoreCase(strWindowState)) {
            imageData = IMG_MAXIMIZED;
        } else if ("MINIMIZED".equalsIgnoreCase(strWindowState)) {
            imageData = IMG_MINIMIZED;
        }
        if (imageData == null) {
            imageData = IMG_DEFAULT;
        }
        return imageData;
    }

    public void dispose() {
        super.dispose();
        ((Element)this.context(Element.class)).detach(this.listener, WindowState.PROP_WINDOW_STATE.name());
    }
}

