/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.facet.IPluginProjectDataModelProperties;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.theme.core.ThemeCore;
import com.liferay.ide.theme.core.operation.ThemeDescriptorHelper;
import com.liferay.ide.theme.core.util.BuildHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ThemeCSSBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "com.liferay.ide.eclipse.theme.core.cssBuilder";
    private BuildHelper buildHelper = new BuildHelper();

    public static IStatus compileTheme(IProject project) throws CoreException {
        SDK sdk = SDKUtil.getSDK((IProject)project);
        if (sdk == null) {
            throw new CoreException(ThemeCore.createErrorStatus("No SDK for project configured. Could not build theme."));
        }
        IStatus status = sdk.compileThemePlugin(project, null);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        ThemeCSSBuilder.ensureLookAndFeelFileExists(project);
        try {
            project.refreshLocal(2, null);
        }
        catch (Exception e) {
            ThemeCore.logError(e);
        }
        return status;
    }

    public static void ensureLookAndFeelFileExists(IProject project) throws CoreException {
        IWebProject lrProject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project);
        if (lrProject == null) {
            return;
        }
        IFile lookAndFeelFile = null;
        IResource res = lrProject.findDocrootResource((IPath)new Path("WEB-INF/liferay-look-and-feel.xml"));
        if (res instanceof IFile && res.exists()) {
            lookAndFeelFile = (IFile)res;
        }
        if (lookAndFeelFile == null) {
            String id = project.getName().replaceAll("-theme", "");
            IResource propertiesFileRes = lrProject.findDocrootResource((IPath)new Path("WEB-INF/liferay-plugin-package.properties"));
            String name = id;
            if (propertiesFileRes instanceof IFile && propertiesFileRes.exists()) {
                Properties props = new Properties();
                try {
                    IFile propsFile = (IFile)propertiesFileRes;
                    InputStream contents = propsFile.getContents();
                    props.load(contents);
                    contents.close();
                    String nameValue = props.getProperty("name");
                    if (!CoreUtil.isNullOrEmpty((String)nameValue)) {
                        name = nameValue;
                    }
                    ThemeDescriptorHelper themeDescriptorHelper = new ThemeDescriptorHelper(project);
                    IWebProject lProject = lrProject;
                    ILiferayPortal portal = (ILiferayPortal)lProject.adapt(ILiferayPortal.class);
                    String version = "6.2.0";
                    if (portal != null) {
                        version = portal.getVersion();
                    }
                    String themeType = lProject.getProperty("theme.type", "vm");
                    themeDescriptorHelper.createDefaultFile((IContainer)lrProject.getDefaultDocrootFolder().getFolder("WEB-INF"), version, id, name, themeType);
                }
                catch (IOException e) {
                    ThemeCore.logError("Unable to load plugin package properties.", e);
                }
            }
        }
    }

    protected void applyDiffsDeltaToDocroot(final IResourceDelta delta, final IContainer docroot, IProgressMonitor monitor) {
        int deltaKind = delta.getKind();
        switch (deltaKind) {
            default: 
        }
        final IPath path = CoreUtil.getResourceLocation((IResource)docroot);
        ILiferayProject liferayProject = LiferayCore.create((Object)this.getProject());
        String themeParent = liferayProject.getProperty("theme.parent", "_styled");
        ILiferayPortal portal = (ILiferayPortal)liferayProject.adapt(ILiferayPortal.class);
        if (portal != null) {
            IPath themesPath = portal.getAppServerPortalDir().append("html/themes");
            final ArrayList<IPath> restorePaths = new ArrayList<IPath>();
            int i = 0;
            while (i < IPluginProjectDataModelProperties.THEME_PARENTS.length) {
                if (IPluginProjectDataModelProperties.THEME_PARENTS[i].equals(themeParent)) {
                    restorePaths.add(themesPath.append(IPluginProjectDataModelProperties.THEME_PARENTS[i]));
                } else if (restorePaths.size() > 0) {
                    restorePaths.add(themesPath.append(IPluginProjectDataModelProperties.THEME_PARENTS[i]));
                }
                ++i;
            }
            new Job("publish theme delta"){

                protected IStatus run(IProgressMonitor monitor) {
                    ThemeCSSBuilder.this.buildHelper.publishDelta(delta, path, restorePaths.toArray(new IPath[0]), monitor);
                    try {
                        docroot.refreshLocal(2, monitor);
                    }
                    catch (Exception e) {
                        ThemeCore.logError(e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        if (kind == 6) {
            this.fullBuild(args, monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(args, monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(Map args, IProgressMonitor monitor) {
        try {
            if (this.shouldFullBuild(args)) {
                ThemeCSSBuilder.compileTheme(this.getProject(args));
            }
        }
        catch (Exception e) {
            ThemeCore.logError("Full build failed for Theme CSS Builder", e);
        }
    }

    protected IProject getProject(Map args) {
        return this.getProject();
    }

    protected void incrementalBuild(IResourceDelta delta, final IProgressMonitor monitor) {
        int deltaKind = delta.getKind();
        if (deltaKind == 2) {
            return;
        }
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    IPath fullResourcePath = resource.getFullPath();
                    String[] stringArray = fullResourcePath.segments();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath relPath;
                        String segment = stringArray[n2];
                        if ("_diffs".equals(segment)) {
                            IFolder diffs;
                            IFolder webappRoot;
                            IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)ThemeCSSBuilder.this.getProject());
                            if (webproject != null && webproject.getDefaultDocrootFolder() != null && (webappRoot = webproject.getDefaultDocrootFolder()) != null && (diffs = webappRoot.getFolder((IPath)new Path("_diffs"))) != null && diffs.exists() && diffs.getFullPath().isPrefixOf(fullResourcePath)) {
                                ThemeCSSBuilder.this.applyDiffsDeltaToDocroot(delta, diffs.getParent(), monitor);
                                return false;
                            }
                        } else if ("build.xml".equals(segment) && (relPath = resource.getProjectRelativePath()) != null && relPath.segmentCount() == 1) {
                            try {
                                ThemeCSSBuilder.compileTheme(resource.getProject());
                            }
                            catch (CoreException e) {
                                ThemeCore.logError("Error compiling theme.", (Exception)((Object)e));
                            }
                        }
                        ++n2;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            ThemeCore.logError((Exception)((Object)e));
        }
    }

    protected boolean shouldFullBuild(Map args) throws CoreException {
        Object[] diffMembers;
        IFolder diffs;
        IFolder webappRoot;
        if (args != null && args.get("force") != null && args.get("force").equals("true")) {
            return true;
        }
        IWebProject lrproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)this.getProject());
        return lrproject != null && lrproject.getDefaultDocrootFolder() != null && (webappRoot = lrproject.getDefaultDocrootFolder()) != null && (diffs = webappRoot.getFolder((IPath)new Path("_diffs"))) != null && diffs.exists() && !CoreUtil.isNullOrEmpty((Object[])(diffMembers = diffs.members()));
    }
}

