/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core.util;

import com.liferay.ide.theme.core.ThemeCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;

public class BuildHelper {
    private static final int BUFFER = 65536;
    private static byte[] buf = new byte[65536];
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private static final File defaultTempDir = ThemeCore.getDefault().getStateLocation().toFile();
    private static final String TEMPFILE_PREFIX = ".tmp-safe-to-delete-";
    private File tempDir = defaultTempDir;

    public BuildHelper() {
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
    }

    private void copyFile(InputStream in, IPath to, long ts, IFile mf) throws CoreException {
        block29: {
            OutputStream out = null;
            File tempFile = null;
            File tempFileParentDir = null;
            try {
                try {
                    File file = to.toFile();
                    tempFileParentDir = file != null && file.getParentFile().exists() ? to.toFile().getParentFile() : this.tempDir;
                    tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + to.getFileExtension(), tempFileParentDir);
                    out = new FileOutputStream(tempFile);
                    int avail = in.read(buf);
                    while (avail > 0) {
                        out.write(buf, 0, avail);
                        avail = in.read(buf);
                    }
                    out.close();
                    out = null;
                    this.moveTempFile(tempFile, file);
                    if (ts != -1L && ts != 0L) {
                        file.setLastModified(ts);
                    }
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception exception) {
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.deleteOnExit();
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception2) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block29;
                    }
                    catch (Exception exception3) {}
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            if (tempFile != null && tempFile.exists()) {
                tempFile.deleteOnExit();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static IStatus[] deleteDirectory(File dir, IProgressMonitor monitor) {
        if (!dir.exists() || !dir.isDirectory()) {
            return new IStatus[]{new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorNotADirectory, (Object)dir.getAbsolutePath()), null)};
        }
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        try {
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            boolean deleteCurrent = true;
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    if (!current.delete()) {
                        status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)files[i].getAbsolutePath()), null));
                        deleteCurrent = false;
                    }
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    IStatus[] stat = BuildHelper.deleteDirectory(current, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)10));
                    if (stat != null && stat.length > 0) {
                        deleteCurrent = false;
                        BuildHelper.addArrayToList(status, stat);
                    }
                }
                ++i;
            }
            if (deleteCurrent && !dir.delete()) {
                status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)dir.getAbsolutePath()), null));
            }
            monitor.done();
        }
        catch (Exception e) {
            ThemeCore.logError("Error deleting directory " + dir.getAbsolutePath(), e);
            status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, e.getLocalizedMessage(), null));
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishSmart(IResource[] resources, IPath path, IProgressMonitor monitor) {
        return this.publishSmart(resources, path, null, monitor);
    }

    public IStatus[] publishSmart(IResource[] resources, IPath path, IPath[] ignore, IProgressMonitor monitor) {
        int toSize;
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        File toDir = path.toFile();
        int fromSize = resources.length;
        String[] fromFileNames = new String[fromSize];
        int i = 0;
        while (i < fromSize) {
            fromFileNames[i] = resources[i].getName();
            ++i;
        }
        ArrayList<String> ignoreFileNames = new ArrayList<String>();
        if (ignore != null) {
            int i2 = 0;
            while (i2 < ignore.length) {
                if (ignore[i2].segmentCount() == 1) {
                    ignoreFileNames.add(ignore[i2].toOSString());
                }
                ++i2;
            }
        }
        File[] toFiles = null;
        String[] toFileNames = null;
        boolean foundExistingDir = false;
        if (toDir.exists()) {
            if (toDir.isDirectory()) {
                foundExistingDir = true;
                toFiles = toDir.listFiles();
                toSize = toFiles.length;
                toFileNames = new String[toSize];
                int i3 = 0;
                while (i3 < toSize) {
                    toFileNames[i3] = toFiles[i3].getName();
                    boolean isDir = toFiles[i3].isDirectory();
                    boolean found = false;
                    int j = 0;
                    while (j < fromSize) {
                        if (toFileNames[i3].equals(fromFileNames[j]) && isDir == resources[j] instanceof IFolder) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        boolean delete = true;
                        for (String preserveFileName : ignoreFileNames) {
                            if (!toFileNames[i3].equals(preserveFileName)) continue;
                            delete = false;
                            break;
                        }
                        if (delete) {
                            if (isDir) {
                                IStatus[] stat = BuildHelper.deleteDirectory(toFiles[i3], null);
                                BuildHelper.addArrayToList(status, stat);
                            } else if (!toFiles[i3].delete()) {
                                status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)toFiles[i3].getAbsolutePath()), null));
                            }
                        }
                        toFiles[i3] = null;
                        toFileNames[i3] = null;
                    }
                    ++i3;
                }
            } else if (!toDir.delete()) {
                status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)toDir.getAbsolutePath()), null));
                IStatus[] stat = new IStatus[status.size()];
                status.toArray(stat);
                return stat;
            }
        }
        if (!foundExistingDir && !toDir.mkdirs()) {
            status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorMkdir, (Object)toDir.getAbsolutePath()), null));
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        if (monitor.isCanceled()) {
            return new IStatus[]{Status.CANCEL_STATUS};
        }
        monitor.worked(50);
        if (toFiles == null && (toFiles = toDir.listFiles()) == null) {
            toFiles = new File[]{};
        }
        toSize = toFiles.length;
        int dw = 0;
        if (toSize > 0) {
            dw = 500 / toSize;
        }
        if (toFileNames == null) {
            toFileNames = new String[toSize];
        }
        long[] toFileMod = new long[toSize];
        int i4 = 0;
        while (i4 < toSize) {
            if (toFiles[i4] != null) {
                if (toFileNames[i4] != null) {
                    toFileNames[i4] = toFiles[i4].getName();
                }
                toFileMod[i4] = toFiles[i4].lastModified();
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < fromSize) {
            IResource current = resources[i4];
            String name = fromFileNames[i4];
            boolean currentIsDir = current instanceof IFolder;
            if (!currentIsDir) {
                boolean copy = true;
                IFile mf = (IFile)current;
                long mod = -1L;
                IFile file = (IFile)mf.getAdapter(IFile.class);
                if (file != null) {
                    mod = file.getLocalTimeStamp();
                } else {
                    File file2 = (File)mf.getAdapter(File.class);
                    mod = file2.lastModified();
                }
                int j = 0;
                while (j < toSize) {
                    if (name.equals(toFileNames[j]) && mod == toFileMod[j]) {
                        copy = false;
                        break;
                    }
                    ++j;
                }
                if (copy) {
                    try {
                        this.copyFile(mf, path.append(name));
                    }
                    catch (CoreException ce) {
                        status.add(ce.getStatus());
                    }
                }
                monitor.worked(dw);
            } else {
                IFolder folder = (IFolder)current;
                IResource[] children = null;
                try {
                    children = folder.members();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                IPath[] ignoreChildren = null;
                if (ignore != null) {
                    ArrayList<IPath> ignoreChildPaths = new ArrayList<IPath>();
                    int j = 0;
                    while (j < ignore.length) {
                        IPath preservePath = ignore[j];
                        if (preservePath.segment(0).equals(name)) {
                            ignoreChildPaths.add(preservePath.removeFirstSegments(1));
                        }
                        ++j;
                    }
                    if (ignoreChildPaths.size() > 0) {
                        ignoreChildren = (IPath[])ignoreChildPaths.toArray(new Path[ignoreChildPaths.size()]);
                    }
                }
                monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{name, name}));
                IStatus[] stat = this.publishSmart(children, path.append(name), ignoreChildren, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)dw));
                BuildHelper.addArrayToList(status, stat);
            }
            ++i4;
        }
        if (monitor.isCanceled()) {
            return new IStatus[]{Status.CANCEL_STATUS};
        }
        monitor.worked(500 - dw * toSize);
        monitor.done();
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishDelta(IResourceDelta[] delta, IPath path, IPath[] restorePaths, IProgressMonitor monitor) {
        if (delta == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size2 = delta.length;
        int i = 0;
        while (i < size2) {
            IStatus[] stat = this.publishDelta(delta[i], path, restorePaths, monitor);
            BuildHelper.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishDelta(IResourceDelta delta, IPath path, IPath[] restorePaths, IProgressMonitor monitor) {
        IPath path2;
        File file;
        IPath diffsRelativePath;
        IPath path22;
        File file2;
        IPath diffsPath;
        IPath diffsRelativePath2;
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        IResource resource = delta.getResource();
        int kind2 = delta.getKind();
        if (resource instanceof IFile) {
            IFile file3 = (IFile)resource;
            try {
                if (kind2 == 2) {
                    BuildHelper.deleteFile(path, file3, restorePaths);
                } else {
                    IPath diffsRelativePath3 = BuildHelper.getDiffsRelativePath(file3.getProjectRelativePath());
                    if (diffsRelativePath3 != null) {
                        IPath path23 = path.append(diffsRelativePath3);
                        File f = path23.toFile().getParentFile();
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                        this.copyFile(file3, path23);
                    }
                }
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        if (kind2 == 1 && (diffsRelativePath2 = BuildHelper.getDiffsRelativePath(diffsPath = resource.getProjectRelativePath())) != null && !(file2 = (path22 = path.append(diffsRelativePath2)).toFile()).exists() && !file2.mkdirs()) {
            status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorMkdir, (Object)path22), null));
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        IResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = this.publishDelta(childDeltas[i], path, restorePaths, monitor);
            BuildHelper.addArrayToList(status, stat);
            ++i;
        }
        if (kind2 == 2 && (diffsRelativePath = BuildHelper.getDiffsRelativePath(resource.getProjectRelativePath())) != null && (file = (path2 = path.append(diffsRelativePath)).toFile()).exists() && !file.delete()) {
            status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private static IPath getDiffsRelativePath(IPath diffsPath) {
        IPath diffsRelativePath = null;
        int i = 0;
        while (i < diffsPath.segmentCount()) {
            if ("_diffs".equals(diffsPath.segment(i))) {
                diffsRelativePath = diffsPath.removeFirstSegments(i + 1);
                break;
            }
            ++i;
        }
        return diffsRelativePath;
    }

    private static void deleteFile(IPath path, IFile file, IPath[] restorePaths) throws CoreException {
        IPath diffsPath = file.getProjectRelativePath();
        IPath diffsRelativePath = BuildHelper.getDiffsRelativePath(diffsPath);
        if (diffsRelativePath != null) {
            IPath path2 = path.append(diffsRelativePath);
            boolean restored = false;
            IPath[] iPathArray = restorePaths;
            int n = restorePaths.length;
            int n2 = 0;
            while (n2 < n) {
                IPath restorePath = iPathArray[n2];
                File restoreFile = restorePath.append(diffsRelativePath).toFile();
                if (restoreFile.exists()) {
                    try {
                        FileUtils.copyFile((File)restoreFile, (File)path2.toFile());
                        restored = true;
                        break;
                    }
                    catch (IOException iOException) {
                        throw new CoreException((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)"Error restoring theme file.", (Object)path2), null));
                    }
                }
                ++n2;
            }
            if (!restored && path2.toFile().exists() && !path2.toFile().delete()) {
                throw new CoreException((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
            }
        }
    }

    private void copyFile(IFile mf, IPath path) throws CoreException {
        if (!this.isCopyFile(mf, path)) {
            return;
        }
        IFile file = (IFile)mf.getAdapter(IFile.class);
        if (file != null) {
            this.copyFile(file.getContents(), path, file.getLocalTimeStamp(), mf);
        } else {
            File file2 = (File)mf.getAdapter(File.class);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file2);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorReading, (Object)file2.getAbsolutePath()), (Throwable)e));
            }
            this.copyFile(in, path, file2.lastModified(), mf);
        }
    }

    protected boolean isCopyFile(IFile moduleFile, IPath toPath) {
        return true;
    }

    public IStatus[] publishFull(IResource[] resources, IPath path, IProgressMonitor monitor) {
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = this.copy(resources[i], path, monitor);
            BuildHelper.addArrayToList(status, stat);
            if (monitor.isCanceled()) break;
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private IStatus[] copy(IResource resource, IPath path, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return new IStatus[0];
        }
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            try {
                IStatus[] stat = this.publishFull(folder.members(), path, monitor);
                BuildHelper.addArrayToList(status, stat);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            IFile mf = (IFile)resource;
            IPath diffsRelativePath = BuildHelper.getDiffsRelativePath(mf.getProjectRelativePath());
            if (diffsRelativePath != null) {
                File f = (path = path.append(diffsRelativePath)).toFile().getParentFile();
                if (f.exists()) {
                    try {
                        this.copyFile(mf, path);
                    }
                    catch (CoreException ce) {
                        status.add(ce.getStatus());
                    }
                } else if (f.mkdirs()) {
                    try {
                        this.copyFile(mf, path);
                    }
                    catch (CoreException ce) {
                        status.add(ce.getStatus());
                    }
                } else {
                    status.add((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorMkdir, (Object)f.getAbsolutePath()), null));
                }
            }
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishToPath(IResource[] resources, IPath path, IProgressMonitor monitor) {
        if (resources == null || resources.length == 0) {
            File file = path.toFile();
            if (file.exists()) {
                file.delete();
            }
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        if (resources.length == 1 && resources[0] instanceof IFile) {
            try {
                this.copyFile((IFile)resources[0], path);
            }
            catch (CoreException e) {
                return new IStatus[]{e.getStatus()};
            }
        }
        return EMPTY_STATUS;
    }

    private void moveTempFile(File tempFile, File file) throws CoreException {
        if (file.exists() && !BuildHelper.safeDelete(file, 2)) {
            try {
                FileInputStream in = new FileInputStream(tempFile);
                IStatus status = this.copyFile(in, file.getPath());
                if (!status.isOK()) {
                    MultiStatus status2 = new MultiStatus("com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)file.toString()), null);
                    status2.add(status);
                    throw new CoreException((IStatus)status2);
                }
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                tempFile.delete();
            }
        }
        if (!BuildHelper.safeRename(tempFile, file, 10)) {
            throw new CoreException((IStatus)new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorRename, (Object)tempFile.toString()), null));
        }
    }

    /*
     * Loose catch block
     */
    private IStatus copyFile(InputStream in, String to) {
        FileOutputStream out = null;
        out = new FileOutputStream(to);
        int avail = in.read(buf);
        while (avail > 0) {
            ((OutputStream)out).write(buf, 0, avail);
            avail = in.read(buf);
        }
        IStatus iStatus = Status.OK_STATUS;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        catch (Exception exception) {}
        return iStatus;
        catch (Exception e) {
            Status status;
            try {
                ThemeCore.logError("Error copying file", e);
                status = new Status(4, "com.liferay.ide.theme.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception exception) {}
            return status;
        }
    }

    private static boolean safeDelete(File f, int retrys) {
        int count = 0;
        while (count < retrys) {
            if (f.delete()) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static boolean safeRename(File from, File to, int retrys) {
        File dir = to.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        int count = 0;
        while (count < retrys) {
            if (from.renameTo(to)) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

