/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.facet;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.facet.IPluginFacetConstants;
import com.liferay.ide.project.core.facet.PluginFacetInstall;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtPluginFacetInstall
extends PluginFacetInstall {
    @Override
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        super.execute(project, fv, config, monitor);
        IDataModel model = (IDataModel)config;
        IDataModel masterModel = (IDataModel)model.getProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM");
        if (masterModel != null && masterModel.getBooleanProperty("IPluginProjectDataModelProperties.CREATE_PROJECT_OPERATION")) {
            String extName = this.masterModel.getStringProperty("IPluginProjectDataModelProperties.EXT_NAME");
            IPath projectTempPath = (IPath)masterModel.getProperty("IPluginProjectDataModelProperties.PROJECT_TEMP_PATH");
            this.processNewFiles(projectTempPath.append(String.valueOf(extName) + "-ext"));
            FileUtil.deleteDir((File)projectTempPath.toFile(), (boolean)true);
            try {
                this.project.refreshLocal(2, monitor);
            }
            catch (Exception e) {
                ProjectCore.logError(e);
            }
            IFolder webappRoot = this.project.getFolder("docroot");
            this.deleteFolder(webappRoot.getFolder("WEB-INF/src"));
            this.deleteFolder(webappRoot.getFolder("WEB-INF/classes"));
        }
        if (this.shouldSetupExtClasspath()) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            List<IClasspathEntry> existingRawClasspath = Arrays.asList(javaProject.getRawClasspath());
            ArrayList<IClasspathEntry> newRawClasspath = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < IPluginFacetConstants.EXT_PLUGIN_SDK_SOURCE_FOLDERS.length) {
                IPath sourcePath = this.project.getFolder(IPluginFacetConstants.EXT_PLUGIN_SDK_SOURCE_FOLDERS[i]).getFullPath();
                IPath outputPath = this.project.getFolder(IPluginFacetConstants.EXT_PLUGIN_SDK_OUTPUT_FOLDERS[i]).getFullPath();
                IClasspathAttribute[] attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"owner.project.facets", (String)"liferay.ext")};
                IClasspathEntry sourceEntry = JavaCore.newSourceEntry((IPath)sourcePath, (IPath[])new IPath[0], (IPath[])new IPath[0], (IPath)outputPath, (IClasspathAttribute[])attributes);
                newRawClasspath.add(sourceEntry);
                ++i;
            }
            for (IClasspathEntry entry : existingRawClasspath) {
                if (entry.getEntryKind() == 3) continue;
                newRawClasspath.add(entry);
            }
            javaProject.setRawClasspath(newRawClasspath.toArray(new IClasspathEntry[0]), this.project.getFolder("docroot/WEB-INF/ext-web/docroot/WEB-INF/classes").getFullPath(), null);
            ProjectUtil.fixExtProjectSrcFolderLinks(this.project);
        }
        this.removeUnneededFolders(this.project);
    }

    private void removeUnneededFolders(IProject project) throws CoreException {
        IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project);
        if (webproject != null && webproject.getDefaultDocrootFolder() != null) {
            IFolder webappRoot = webproject.getDefaultDocrootFolder();
            this.deleteFolder(webappRoot.getFolder("WEB-INF/lib"));
        }
    }

    protected void deleteFolder(IFolder folder) throws CoreException {
        if (folder != null && folder.exists()) {
            folder.delete(true, null);
        }
    }

    protected void fixTilesDefExtFile() {
        IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)this.project);
        IFolder webappRoot = webproject.getDefaultDocrootFolder();
        IFile tilesDefExtFile = webappRoot.getFile("WEB-INF/ext-web/docroot/WEB-INF/tiles-defs-ext.xml");
        if (tilesDefExtFile.exists()) {
            try {
                IDOMModel domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(tilesDefExtFile);
                domModel.aboutToChangeModel();
                IDOMDocument document = domModel.getDocument();
                Element root = document.getDocumentElement();
                Element def = document.createElement("definition");
                def.setAttribute("name", "");
                root.appendChild(def);
                root.appendChild(document.createTextNode("\n"));
                new FormatProcessorXML().formatNode((Node)def);
                domModel.changedModel();
                domModel.save();
                domModel.releaseFromEdit();
                tilesDefExtFile.refreshLocal(2, null);
            }
            catch (Exception e) {
                ProjectCore.logError(e);
            }
        }
    }

    @Override
    protected String getDefaultOutputLocation() {
        return "docroot/WEB-INF/ext-web/docroot/WEB-INF/classes";
    }
}

