/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class SDKLocationListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        SDKLocationListener.updateLocation(this.op(event));
    }

    protected NewLiferayPluginProjectOp op(PropertyContentEvent event) {
        return (NewLiferayPluginProjectOp)event.property().element().nearest(NewLiferayPluginProjectOp.class);
    }

    public static void updateLocation(NewLiferayPluginProjectOp op) {
        Path newLocationBase = null;
        Path sdkLocation = (Path)op.getSdkLocation().content(true);
        if (sdkLocation == null) {
            return;
        }
        SDK sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)sdkLocation));
        if (sdk != null) {
            switch ((PluginType)((Object)op.getPluginType().content(true))) {
                case portlet: 
                case servicebuilder: {
                    newLocationBase = sdkLocation.append("portlets");
                    break;
                }
                case ext: {
                    newLocationBase = sdkLocation.append("ext");
                    break;
                }
                case hook: {
                    newLocationBase = sdkLocation.append("hooks");
                    break;
                }
                case layouttpl: {
                    newLocationBase = sdkLocation.append("layouttpl");
                    break;
                }
                case theme: {
                    newLocationBase = sdkLocation.append("themes");
                    break;
                }
                case web: {
                    newLocationBase = sdkLocation.append("webs");
                }
            }
        } else {
            return;
        }
        if (newLocationBase != null) {
            NewLiferayPluginProjectOpMethods.updateLocation(op, newLocationBase);
        }
    }
}

