/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.upgrade;

import com.liferay.ide.project.core.AbstractUpgradeProjectHandler;
import com.liferay.ide.project.core.UpgradeProjectHandlerReader;
import com.liferay.ide.project.core.model.NamedItem;
import com.liferay.ide.project.core.upgrade.UpgradeLiferayProjectsOp;
import com.liferay.ide.project.core.util.ProjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;

public class UpgradeLiferayProjectsOpMethods {
    public static final Status execute(UpgradeLiferayProjectsOp op, ProgressMonitor pm) {
        Status[] upgradeStatuses;
        Status retval = Status.createOkStatus();
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Upgrading Liferay plugin projects (this process may take several minutes)", 30);
        ElementList<NamedItem> projectItems = op.getSelectedProjects();
        ElementList<NamedItem> upgradeActions = op.getSelectedActions();
        String runtimeName = (String)op.getRuntimeName().content();
        ArrayList<String> projectItemNames = new ArrayList<String>();
        ArrayList<String> projectActionItems = new ArrayList<String>();
        for (NamedItem projectItem : projectItems) {
            projectItemNames.add((String)projectItem.getName().content());
        }
        for (NamedItem upgradeAction : upgradeActions) {
            projectActionItems.add((String)upgradeAction.getName().content());
        }
        Status[] statusArray = upgradeStatuses = UpgradeLiferayProjectsOpMethods.performUpgrade(projectItemNames, projectActionItems, runtimeName, monitor);
        int n = upgradeStatuses.length;
        int n2 = 0;
        while (n2 < n) {
            Status s = statusArray[n2];
            if (!s.ok()) {
                retval = Status.createErrorStatus((String)"Some upgrade actions failed, please see Eclipse error log for more details");
            }
            ++n2;
        }
        return retval;
    }

    private static HashMap<String, AbstractUpgradeProjectHandler> getActionMap(List<AbstractUpgradeProjectHandler> upgradeActions) {
        HashMap<String, AbstractUpgradeProjectHandler> actionMaps = new HashMap<String, AbstractUpgradeProjectHandler>();
        for (AbstractUpgradeProjectHandler upgradeHandler : upgradeActions) {
            actionMaps.put(upgradeHandler.getName(), upgradeHandler);
        }
        return actionMaps;
    }

    private static final Status[] performUpgrade(List<String> projectItems, List<String> projectActions, String runtimeName, IProgressMonitor monitor) {
        ArrayList<Status> retval = new ArrayList<Status>();
        int worked = 0;
        int workUnit = projectItems.size();
        int actionUnit = projectActions.size();
        int totalWork = 100;
        int perUnit = totalWork / (workUnit * actionUnit);
        monitor.beginTask("Upgrading Project ", totalWork);
        UpgradeProjectHandlerReader upgradeLiferayProjectActionReader = new UpgradeProjectHandlerReader();
        HashMap<String, AbstractUpgradeProjectHandler> actionMap = UpgradeLiferayProjectsOpMethods.getActionMap(upgradeLiferayProjectActionReader.getUpgradeActions());
        for (String projectItem : projectItems) {
            if (projectItem == null) continue;
            IProject project = ProjectUtil.getProject(projectItem);
            monitor.subTask("Upgrading project " + project.getName());
            for (String action : projectActions) {
                AbstractUpgradeProjectHandler upgradeLiferayProjectAction = actionMap.get(action);
                Status status = upgradeLiferayProjectAction.execute(project, runtimeName, monitor, perUnit);
                retval.add(status);
                monitor.worked(worked += totalWork / (workUnit * actionUnit));
            }
        }
        return retval.toArray(new Status[0]);
    }
}

