/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.Throwable;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NotificationAction;

public class NewErrorNotification
extends Notification {
    private final ErrorReport report;

    public NewErrorNotification(ErrorReport report, EventBus bus) {
        super("org.eclipse.epp.logging.aeri.notifications.event.newReport", bus);
        this.report = report;
    }

    public String getDescription() {
        StringBuilder b = new StringBuilder();
        Throwable exception = this.report.getStatus().getException();
        if (exception != null) {
            String message = String.valueOf(Reports.toShortClassName(exception.getClassName())) + ": " + (String)Optional.fromNullable((Object)exception.getMessage()).or((Object)"");
            b.append(StringUtils.abbreviate((String)message, (int)120));
        }
        b.append("\n\nDo you want to report this error?");
        return b.toString();
    }

    public String getLabel() {
        return "Message: " + this.report.getStatus().getMessage();
    }

    public ErrorReport getReport() {
        return this.report;
    }

    @Override
    public List<NotificationAction> getActions() {
        NotificationAction a1 = new NotificationAction("View Details"){

            @Override
            public void execute() {
                NewErrorNotification.this.closeWithEvent(new Events.NewReportShowDetailsRequest(NewErrorNotification.this.report));
            }
        };
        NotificationAction a2 = new NotificationAction("Send"){

            @Override
            public void execute() {
                NewErrorNotification.this.closeWithEvent(new Events.SendReportsRequest());
            }
        };
        return Lists.newArrayList((Object[])new NotificationAction[]{a1, a2});
    }

    @Override
    public String getTitle() {
        return "Error logged in " + this.getReport().getStatus().getPluginId();
    }

    @Override
    public void unhandled() {
        this.closeWithEvent(new Events.NewReportNotificationTimedOut(this.report));
    }
}

